; This file was created with EvAVRbuilder.dll library. 20.04.2021 13:40:24

//-- device --
;***** THIS IS A MACHINE GENERATED FILE - DO NOT EDIT ********************
;***** Created: 2011-08-25 21:00 ******* Source: ATtiny2313A.xml *********
;*************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
;* 
;* Number            : AVR000
;* File Name         : "tn2313Adef.inc"
;* Title             : Register/Bit Definitions for the ATtiny2313A
;* Date              : 2011-08-25
;* Version           : 2.35
;* Support E-mail    : avr@atmel.com
;* Target MCU        : ATtiny2313A
;* 
;* DESCRIPTION
;* When including this file in the assembly program file, all I/O register 
;* names and I/O register bit names appearing in the data book can be used.
;* In addition, the six registers forming the three data pointers X, Y and 
;* Z have been assigned names XL - ZH. Highest RAM address for Internal 
;* SRAM is also defined 
;* 
;* The Register names are represented by their hexadecimal address.
;* 
;* The Register Bit names are represented by their bit number (0-7).
;* 
;* Please observe the difference in using the bit names with instructions
;* such as "sbr"/"cbr" (set/clear bit in register) and "sbrs"/"sbrc"
;* (skip if bit in register set/cleared). The following example illustrates
;* this:
;* 
;* in    r16,PORTB             ;read PORTB latch
;* sbr   r16,(1<<PB6)+(1<<PB5) ;set PB6 and PB5 (use masks, not bit#)
;* out   PORTB,r16             ;output to PORTB
;* 
;* in    r16,TIFR              ;read the Timer Interrupt Flag Register
;* sbrc  r16,TOV0              ;test the overflow flag (use bit#)
;* rjmp  TOV0_is_set           ;jump if set
;* ...                         ;otherwise do something else
;*************************************************************************

#ifndef _TN2313ADEF_INC_
#define _TN2313ADEF_INC_


#pragma partinc 0

; ***** SPECIFY DEVICE ***************************************************
.device ATtiny2313A
#pragma AVRPART ADMIN PART_NAME ATtiny2313A
.equ	SIGNATURE_000	= 0x1e
.equ	SIGNATURE_001	= 0x91
.equ	SIGNATURE_002	= 0x0a

#pragma AVRPART CORE CORE_VERSION V2
#pragma AVRPART CORE NEW_INSTRUCTIONS lpm rd,z+


; ***** I/O REGISTER DEFINITIONS *****************************************
; NOTE:
; Definitions marked "MEMORY MAPPED"are extended I/O ports
; and cannot be used with IN/OUT instructions
.equ	SREG	= 0x3f
.equ	SPL	= 0x3d
.equ	OCR0B	= 0x3c
.equ	GIMSK	= 0x3b
.equ	EIFR	= 0x3a
.equ	TIMSK	= 0x39
.equ	TIFR	= 0x38
.equ	SPMCSR	= 0x37
.equ	OCR0A	= 0x36
.equ	MCUCR	= 0x35
.equ	MCUSR	= 0x34
.equ	TCCR0B	= 0x33
.equ	TCNT0	= 0x32
.equ	OSCCAL	= 0x31
.equ	TCCR0A	= 0x30
.equ	TCCR1A	= 0x2f
.equ	TCCR1B	= 0x2e
.equ	TCNT1L	= 0x2c
.equ	TCNT1H	= 0x2d
.equ	OCR1AL	= 0x2a
.equ	OCR1AH	= 0x2b
.equ	OCR1BL	= 0x28
.equ	OCR1BH	= 0x29
.equ	CLKPR	= 0x26
.equ	ICR1L	= 0x24
.equ	ICR1H	= 0x25
.equ	GTCCR	= 0x23
.equ	TCCR1C	= 0x22
.equ	WDTCR	= 0x21
.equ	PCMSK	= 0x20
.equ	EEAR	= 0x1e
.equ	EEDR	= 0x1d
.equ	EECR	= 0x1c
.equ	PORTA	= 0x1b
.equ	DDRA	= 0x1a
.equ	PINA	= 0x19
.equ	PORTB	= 0x18
.equ	DDRB	= 0x17
.equ	PINB	= 0x16
.equ	GPIOR2	= 0x15
.equ	GPIOR1	= 0x14
.equ	GPIOR0	= 0x13
.equ	PORTD	= 0x12
.equ	DDRD	= 0x11
.equ	PIND	= 0x10
.equ	USIDR	= 0x0f
.equ	USISR	= 0x0e
.equ	USICR	= 0x0d
.equ	UDR	= 0x0c
.equ	UCSRA	= 0x0b
.equ	UCSRB	= 0x0a
.equ	UBRRL	= 0x09
.equ	ACSR	= 0x08
.equ	BODCR	= 0x07
.equ	PRR	= 0x06
.equ	PCMSK2	= 0x05
.equ	PCMSK1	= 0x04
.equ	UCSRC	= 0x03
.equ	UBRRH	= 0x02
.equ	DIDR	= 0x01


; ***** BIT DEFINITIONS **************************************************

; ***** PORTB ************************
; PORTB - Port B Data Register
.equ	PORTB0	= 0	; Port B Data Register bit 0
.equ	PB0	= 0	; For compatibility
.equ	PORTB1	= 1	; Port B Data Register bit 1
.equ	PB1	= 1	; For compatibility
.equ	PORTB2	= 2	; Port B Data Register bit 2
.equ	PB2	= 2	; For compatibility
.equ	PORTB3	= 3	; Port B Data Register bit 3
.equ	PB3	= 3	; For compatibility
.equ	PORTB4	= 4	; Port B Data Register bit 4
.equ	PB4	= 4	; For compatibility
.equ	PORTB5	= 5	; Port B Data Register bit 5
.equ	PB5	= 5	; For compatibility
.equ	PORTB6	= 6	; Port B Data Register bit 6
.equ	PB6	= 6	; For compatibility
.equ	PORTB7	= 7	; Port B Data Register bit 7
.equ	PB7	= 7	; For compatibility

; DDRB - Port B Data Direction Register
.equ	DDB0	= 0	; Port B Data Direction Register bit 0
.equ	DDB1	= 1	; Port B Data Direction Register bit 1
.equ	DDB2	= 2	; Port B Data Direction Register bit 2
.equ	DDB3	= 3	; Port B Data Direction Register bit 3
.equ	DDB4	= 4	; Port B Data Direction Register bit 4
.equ	DDB5	= 5	; Port B Data Direction Register bit 5
.equ	DDB6	= 6	; Port B Data Direction Register bit 6
.equ	DDB7	= 7	; Port B Data Direction Register bit 7

; PINB - Port B Input Pins
.equ	PINB0	= 0	; Port B Input Pins bit 0
.equ	PINB1	= 1	; Port B Input Pins bit 1
.equ	PINB2	= 2	; Port B Input Pins bit 2
.equ	PINB3	= 3	; Port B Input Pins bit 3
.equ	PINB4	= 4	; Port B Input Pins bit 4
.equ	PINB5	= 5	; Port B Input Pins bit 5
.equ	PINB6	= 6	; Port B Input Pins bit 6
.equ	PINB7	= 7	; Port B Input Pins bit 7


; ***** TIMER_COUNTER_0 **************
; TIMSK - Timer/Counter Interrupt Mask Register
.equ	OCIE0A	= 0	; Timer/Counter0 Output Compare Match A Interrupt Enable
.equ	TOIE0	= 1	; Timer/Counter0 Overflow Interrupt Enable
.equ	OCIE0B	= 2	; Timer/Counter0 Output Compare Match B Interrupt Enable

; TIFR - Timer/Counter Interrupt Flag register
.equ	OCF0A	= 0	; Timer/Counter0 Output Compare Flag 0A
.equ	TOV0	= 1	; Timer/Counter0 Overflow Flag
.equ	OCF0B	= 2	; Timer/Counter0 Output Compare Flag 0B

; OCR0B - Timer/Counter0 Output Compare Register
.equ	OCR0_0	= 0	; 
.equ	OCR0_1	= 1	; 
.equ	OCR0_2	= 2	; 
.equ	OCR0_3	= 3	; 
.equ	OCR0_4	= 4	; 
.equ	OCR0_5	= 5	; 
.equ	OCR0_6	= 6	; 
.equ	OCR0_7	= 7	; 

; OCR0A - Timer/Counter0 Output Compare Register
.equ	OCR0A_0	= 0	; 
.equ	OCR0A_1	= 1	; 
.equ	OCR0A_2	= 2	; 
.equ	OCR0A_3	= 3	; 
.equ	OCR0A_4	= 4	; 
.equ	OCR0A_5	= 5	; 
.equ	OCR0A_6	= 6	; 
.equ	OCR0A_7	= 7	; 

; TCCR0A - Timer/Counter  Control Register A
.equ	WGM00	= 0	; Waveform Generation Mode
.equ	WGM01	= 1	; Waveform Generation Mode
.equ	COM0B0	= 4	; Compare Match Output B Mode
.equ	COM0B1	= 5	; Compare Match Output B Mode
.equ	COM0A0	= 6	; Compare Match Output A Mode
.equ	COM0A1	= 7	; Compare Match Output A Mode

; TCNT0 - Timer/Counter0
.equ	TCNT0_0	= 0	; 
.equ	TCNT0_1	= 1	; 
.equ	TCNT0_2	= 2	; 
.equ	TCNT0_3	= 3	; 
.equ	TCNT0_4	= 4	; 
.equ	TCNT0_5	= 5	; 
.equ	TCNT0_6	= 6	; 
.equ	TCNT0_7	= 7	; 

; TCCR0B - Timer/Counter Control Register B
.equ	TCCR0	= TCCR0B	; For compatibility
.equ	CS00	= 0	; Clock Select
.equ	CS01	= 1	; Clock Select
.equ	CS02	= 2	; Clock Select
.equ	WGM02	= 3	; 
.equ	FOC0B	= 6	; Force Output Compare B
.equ	FOC0A	= 7	; Force Output Compare B


; ***** TIMER_COUNTER_1 **************
; TIMSK - Timer/Counter Interrupt Mask Register
.equ	ICIE1	= 3	; Timer/Counter1 Input Capture Interrupt Enable
.equ	TICIE	= ICIE1	; For compatibility
.equ	OCIE1B	= 5	; Timer/Counter1 Output CompareB Match Interrupt Enable
.equ	OCIE1A	= 6	; Timer/Counter1 Output CompareA Match Interrupt Enable
.equ	TOIE1	= 7	; Timer/Counter1 Overflow Interrupt Enable

; TIFR - Timer/Counter Interrupt Flag register
.equ	ICF1	= 3	; Input Capture Flag 1
.equ	OCF1B	= 5	; Output Compare Flag 1B
.equ	OCF1A	= 6	; Output Compare Flag 1A
.equ	TOV1	= 7	; Timer/Counter1 Overflow Flag

; TCCR1A - Timer/Counter1 Control Register A
.equ	WGM10	= 0	; Pulse Width Modulator Select Bit 0
.equ	PWM10	= WGM10	; For compatibility
.equ	WGM11	= 1	; Pulse Width Modulator Select Bit 1
.equ	PWM11	= WGM11	; For compatibility
.equ	COM1B0	= 4	; Comparet Ouput Mode 1B, bit 0
.equ	COM1B1	= 5	; Compare Output Mode 1B, bit 1
.equ	COM1A0	= 6	; Comparet Ouput Mode 1A, bit 0
.equ	COM1A1	= 7	; Compare Output Mode 1A, bit 1

; TCCR1B - Timer/Counter1 Control Register B
.equ	CS10	= 0	; Clock Select bit 0
.equ	CS11	= 1	; Clock Select 1 bit 1
.equ	CS12	= 2	; Clock Select1 bit 2
.equ	WGM12	= 3	; Waveform Generation Mode Bit 2
.equ	CTC1	= WGM12	; For compatibility
.equ	WGM13	= 4	; Waveform Generation Mode Bit 3
.equ	ICES1	= 6	; Input Capture 1 Edge Select
.equ	ICNC1	= 7	; Input Capture 1 Noise Canceler

; TCCR1C - Timer/Counter1 Control Register C
.equ	FOC1B	= 6	; Force Output Compare for Channel B
.equ	FOC1A	= 7	; Force Output Compare for Channel A


; ***** WATCHDOG *********************
; WDTCR - Watchdog Timer Control Register
.equ	WDTCSR	= WDTCR	; For compatibility
.equ	WDP0	= 0	; Watch Dog Timer Prescaler bit 0
.equ	WDP1	= 1	; Watch Dog Timer Prescaler bit 1
.equ	WDP2	= 2	; Watch Dog Timer Prescaler bit 2
.equ	WDE	= 3	; Watch Dog Enable
.equ	WDCE	= 4	; Watchdog Change Enable
.equ	WDTOE	= WDCE	; For compatibility
.equ	WDP3	= 5	; Watchdog Timer Prescaler Bit 3
.equ	WDIE	= 6	; Watchdog Timeout Interrupt Enable
.equ	WDIF	= 7	; Watchdog Timeout Interrupt Flag


; ***** USART ************************
; UDR - USART I/O Data Register
.equ	UDR0	= 0	; USART I/O Data Register bit 0
.equ	UDR1	= 1	; USART I/O Data Register bit 1
.equ	UDR2	= 2	; USART I/O Data Register bit 2
.equ	UDR3	= 3	; USART I/O Data Register bit 3
.equ	UDR4	= 4	; USART I/O Data Register bit 4
.equ	UDR5	= 5	; USART I/O Data Register bit 5
.equ	UDR6	= 6	; USART I/O Data Register bit 6
.equ	UDR7	= 7	; USART I/O Data Register bit 7

; UCSRA - USART Control and Status Register A
.equ	USR	= UCSRA	; For compatibility
.equ	MPCM	= 0	; Multi-processor Communication Mode
.equ	U2X	= 1	; Double the USART Transmission Speed
.equ	UPE	= 2	; USART Parity Error
.equ	PE	= UPE	; For compatibility
.equ	DOR	= 3	; Data overRun
.equ	FE	= 4	; Framing Error
.equ	UDRE	= 5	; USART Data Register Empty
.equ	TXC	= 6	; USART Transmitt Complete
.equ	RXC	= 7	; USART Receive Complete

; UCSRB - USART Control and Status Register B
.equ	UCR	= UCSRB	; For compatibility
.equ	TXB8	= 0	; Transmit Data Bit 8
.equ	RXB8	= 1	; Receive Data Bit 8
.equ	UCSZ2	= 2	; Character Size
.equ	CHR9	= UCSZ2	; For compatibility
.equ	TXEN	= 3	; Transmitter Enable
.equ	RXEN	= 4	; Receiver Enable
.equ	UDRIE	= 5	; USART Data register Empty Interrupt Enable
.equ	TXCIE	= 6	; TX Complete Interrupt Enable
.equ	RXCIE	= 7	; RX Complete Interrupt Enable

; UCSRC - USART Control and Status Register C
.equ	UCPOL	= 0	; Clock Polarity
.equ	UCSZ0	= 1	; Character Size Bit 0
.equ	UCSZ1	= 2	; Character Size Bit 1
.equ	USBS	= 3	; Stop Bit Select
.equ	UPM0	= 4	; Parity Mode Bit 0
.equ	UPM1	= 5	; Parity Mode Bit 1
.equ	UMSEL	= 6	; USART Mode Select

.equ	UBRR	= UBRRL	; For compatibility

; ***** ANALOG_COMPARATOR ************
; ACSR - Analog Comparator Control And Status Register
.equ	ACIS0	= 0	; Analog Comparator Interrupt Mode Select bit 0
.equ	ACIS1	= 1	; Analog Comparator Interrupt Mode Select bit 1
.equ	ACIC	= 2	; 
.equ	ACIE	= 3	; Analog Comparator Interrupt Enable
.equ	ACI	= 4	; Analog Comparator Interrupt Flag
.equ	ACO	= 5	; Analog Compare Output
.equ	ACBG	= 6	; Analog Comparator Bandgap Select
.equ	ACD	= 7	; Analog Comparator Disable

; DIDR - Digital Input Disable Register 1
.equ	AIN0D	= 0	; AIN0 Digital Input Disable
.equ	AIN1D	= 1	; AIN1 Digital Input Disable


; ***** PORTD ************************
; PORTD - Data Register, Port D
.equ	PORTD0	= 0	; 
.equ	PD0	= 0	; For compatibility
.equ	PORTD1	= 1	; 
.equ	PD1	= 1	; For compatibility
.equ	PORTD2	= 2	; 
.equ	PD2	= 2	; For compatibility
.equ	PORTD3	= 3	; 
.equ	PD3	= 3	; For compatibility
.equ	PORTD4	= 4	; 
.equ	PD4	= 4	; For compatibility
.equ	PORTD5	= 5	; 
.equ	PD5	= 5	; For compatibility
.equ	PORTD6	= 6	; 
.equ	PD6	= 6	; For compatibility

; DDRD - Data Direction Register, Port D
.equ	DDD0	= 0	; 
.equ	DDD1	= 1	; 
.equ	DDD2	= 2	; 
.equ	DDD3	= 3	; 
.equ	DDD4	= 4	; 
.equ	DDD5	= 5	; 
.equ	DDD6	= 6	; 

; PIND - Input Pins, Port D
.equ	PIND0	= 0	; 
.equ	PIND1	= 1	; 
.equ	PIND2	= 2	; 
.equ	PIND3	= 3	; 
.equ	PIND4	= 4	; 
.equ	PIND5	= 5	; 
.equ	PIND6	= 6	; 


; ***** EEPROM ***********************
; EEAR - EEPROM Read/Write Access
.equ	EEARL	= EEAR	; For compatibility
.equ	EEAR0	= 0	; EEPROM Read/Write Access bit 0
.equ	EEAR1	= 1	; EEPROM Read/Write Access bit 1
.equ	EEAR2	= 2	; EEPROM Read/Write Access bit 2
.equ	EEAR3	= 3	; EEPROM Read/Write Access bit 3
.equ	EEAR4	= 4	; EEPROM Read/Write Access bit 4
.equ	EEAR5	= 5	; EEPROM Read/Write Access bit 5
.equ	EEAR6	= 6	; EEPROM Read/Write Access bit 6

; EEDR - EEPROM Data Register
.equ	EEDR0	= 0	; EEPROM Data Register bit 0
.equ	EEDR1	= 1	; EEPROM Data Register bit 1
.equ	EEDR2	= 2	; EEPROM Data Register bit 2
.equ	EEDR3	= 3	; EEPROM Data Register bit 3
.equ	EEDR4	= 4	; EEPROM Data Register bit 4
.equ	EEDR5	= 5	; EEPROM Data Register bit 5
.equ	EEDR6	= 6	; EEPROM Data Register bit 6
.equ	EEDR7	= 7	; EEPROM Data Register bit 7

; EECR - EEPROM Control Register
.equ	EERE	= 0	; EEPROM Read Enable
.equ	EEPE	= 1	; EEPROM Write Enable
.equ	EEWE	= EEPE	; For compatibility
.equ	EEMPE	= 2	; EEPROM Master Write Enable
.equ	EEMWE	= EEMPE	; For compatibility
.equ	EERIE	= 3	; EEProm Ready Interrupt Enable
.equ	EEPM0	= 4	; 
.equ	EEPM1	= 5	; 


; ***** PORTA ************************
; PORTA - Port A Data Register
.equ	PORTA0	= 0	; Port A Data Register bit 0
.equ	PA0	= 0	; For compatibility
.equ	PORTA1	= 1	; Port A Data Register bit 1
.equ	PA1	= 1	; For compatibility
.equ	PORTA2	= 2	; Port A Data Register bit 2
.equ	PA2	= 2	; For compatibility

; DDRA - Port A Data Direction Register
.equ	DDA0	= 0	; Data Direction Register, Port A, bit 0
.equ	DDA1	= 1	; Data Direction Register, Port A, bit 1
.equ	DDA2	= 2	; Data Direction Register, Port A, bit 2

; PINA - Port A Input Pins
.equ	PINA0	= 0	; Input Pins, Port A bit 0
.equ	PINA1	= 1	; Input Pins, Port A bit 1
.equ	PINA2	= 2	; Input Pins, Port A bit 2


; ***** USI **************************
; USIDR - USI Data Register
.equ	USIDR0	= 0	; USI Data Register bit 0
.equ	USIDR1	= 1	; USI Data Register bit 1
.equ	USIDR2	= 2	; USI Data Register bit 2
.equ	USIDR3	= 3	; USI Data Register bit 3
.equ	USIDR4	= 4	; USI Data Register bit 4
.equ	USIDR5	= 5	; USI Data Register bit 5
.equ	USIDR6	= 6	; USI Data Register bit 6
.equ	USIDR7	= 7	; USI Data Register bit 7

; USISR - USI Status Register
.equ	USICNT0	= 0	; USI Counter Value Bit 0
.equ	USICNT1	= 1	; USI Counter Value Bit 1
.equ	USICNT2	= 2	; USI Counter Value Bit 2
.equ	USICNT3	= 3	; USI Counter Value Bit 3
.equ	USIDC	= 4	; Data Output Collision
.equ	USIPF	= 5	; Stop Condition Flag
.equ	USIOIF	= 6	; Counter Overflow Interrupt Flag
.equ	USISIF	= 7	; Start Condition Interrupt Flag

; USICR - USI Control Register
.equ	USITC	= 0	; Toggle Clock Port Pin
.equ	USICLK	= 1	; Clock Strobe
.equ	USICS0	= 2	; USI Clock Source Select Bit 0
.equ	USICS1	= 3	; USI Clock Source Select Bit 1
.equ	USIWM0	= 4	; USI Wire Mode Bit 0
.equ	USIWM1	= 5	; USI Wire Mode Bit 1
.equ	USIOIE	= 6	; Counter Overflow Interrupt Enable
.equ	USISIE	= 7	; Start Condition Interrupt Enable


; ***** EXTERNAL_INTERRUPT ***********
; GIMSK - General Interrupt Mask Register
.equ	PCIE	= 5	; 
.equ	INT0	= 6	; External Interrupt Request 0 Enable
.equ	INT1	= 7	; External Interrupt Request 1 Enable

; EIFR - Extended Interrupt Flag Register
.equ	GIFR	= EIFR	; For compatibility
.equ	PCIF	= 5	; 
.equ	INTF0	= 6	; External Interrupt Flag 0
.equ	INTF1	= 7	; External Interrupt Flag 1

; PCMSK2 - Pin Change Interrupt Mask Register 2
.equ	PCINT11	= 0	; Pin Change Interrupt Mask 11
.equ	PCINT12	= 1	; Pin Change Interrupt Mask 12
.equ	PCINT13	= 2	; Pin Change Interrupt Mask 13
.equ	PCINT14	= 3	; Pin Change Interrupt Mask 14
.equ	PCINT15	= 4	; Pin Change Interrupt Mask 15
.equ	PCINT16	= 5	; Pin Change Interrupt Mask 16
.equ	PCINT17	= 6	; Pin Change Interrupt Mask 17

; PCMSK1 - Pin Change Interrupt Mask Register 1
.equ	PCINT8	= 0	; Pin Change Interrupt Mask 8
.equ	PCINT9	= 1	; Pin Change Interrupt Mask 9
.equ	PCINT10	= 2	; Pin Change Interrupt Mask 10


; ***** CPU **************************
; SREG - Status Register
.equ	SREG_C	= 0	; Carry Flag
.equ	SREG_Z	= 1	; Zero Flag
.equ	SREG_N	= 2	; Negative Flag
.equ	SREG_V	= 3	; Two's Complement Overflow Flag
.equ	SREG_S	= 4	; Sign Bit
.equ	SREG_H	= 5	; Half Carry Flag
.equ	SREG_T	= 6	; Bit Copy Storage
.equ	SREG_I	= 7	; Global Interrupt Enable

; SPMCSR - Store Program Memory Control and Status register
.equ	SPMEN	= 0	; Store Program Memory Enable
.equ	PGERS	= 1	; Page Erase
.equ	PGWRT	= 2	; Page Write
.equ	RFLB	= 3	; Read Fuse and Lock Bits
.equ	CTPB	= 4	; Clear Temporary Page Buffer

; MCUCR - MCU Control Register
.equ	ISC00	= 0	; Interrupt Sense Control 0 bit 0
.equ	ISC01	= 1	; Interrupt Sense Control 0 bit 1
.equ	ISC10	= 2	; Interrupt Sense Control 1 bit 0
.equ	ISC11	= 3	; Interrupt Sense Control 1 bit 1
.equ	SM0	= 4	; Sleep Mode Select Bit 0
.equ	SM	= SM0	; For compatibility
.equ	SE	= 5	; Sleep Enable
.equ	SM1	= 6	; Sleep Mode Select Bit 1
.equ	PUD	= 7	; Pull-up Disable

; CLKPR - Clock Prescale Register
.equ	CLKPS0	= 0	; Clock Prescaler Select Bit 0
.equ	CLKPS1	= 1	; Clock Prescaler Select Bit 1
.equ	CLKPS2	= 2	; Clock Prescaler Select Bit 2
.equ	CLKPS3	= 3	; Clock Prescaler Select Bit 3
.equ	CLKPCE	= 7	; Clock Prescaler Change Enable

; MCUSR - MCU Status register
.equ	PORF	= 0	; Power-On Reset Flag
.equ	EXTRF	= 1	; External Reset Flag
.equ	BORF	= 2	; Brown-out Reset Flag
.equ	WDRF	= 3	; Watchdog Reset Flag

; OSCCAL - Oscillator Calibration Register
.equ	CAL0	= 0	; Oscillatro Calibration Value Bit 0
.equ	CAL1	= 1	; Oscillatro Calibration Value Bit 1
.equ	CAL2	= 2	; Oscillatro Calibration Value Bit 2
.equ	CAL3	= 3	; Oscillatro Calibration Value Bit 3
.equ	CAL4	= 4	; Oscillatro Calibration Value Bit 4
.equ	CAL5	= 5	; Oscillatro Calibration Value Bit 5
.equ	CAL6	= 6	; Oscillatro Calibration Value Bit 6

; GTCCR - General Timer Counter Control Register
.equ	SFIOR	= GTCCR	; For compatibility
.equ	PSR10	= 0	; 

; PCMSK - Pin-Change Mask register
.equ	PCINT0	= 0	; Pin-Change Interrupt 0
.equ	PCINT1	= 1	; Pin-Change Interrupt 1
.equ	PCINT2	= 2	; Pin-Change Interrupt 2
.equ	PCINT3	= 3	; Pin-Change Interrupt 3
.equ	PCINT4	= 4	; Pin-Change Interrupt 4
.equ	PCINT5	= 5	; Pin-Change Interrupt 5
.equ	PCINT6	= 6	; Pin-Change Interrupt 6
.equ	PCINT7	= 7	; Pin-Change Interrupt 7

; GPIOR2 - General Purpose I/O Register 2
.equ	GPIOR20	= 0	; General Purpose I/O Register 2 bit 0
.equ	GPIOR21	= 1	; General Purpose I/O Register 2 bit 1
.equ	GPIOR22	= 2	; General Purpose I/O Register 2 bit 2
.equ	GPIOR23	= 3	; General Purpose I/O Register 2 bit 3
.equ	GPIOR24	= 4	; General Purpose I/O Register 2 bit 4
.equ	GPIOR25	= 5	; General Purpose I/O Register 2 bit 5
.equ	GPIOR26	= 6	; General Purpose I/O Register 2 bit 6
.equ	GPIOR27	= 7	; General Purpose I/O Register 2 bit 7

; GPIOR1 - General Purpose I/O Register 1
.equ	GPIOR10	= 0	; General Purpose I/O Register 1 bit 0
.equ	GPIOR11	= 1	; General Purpose I/O Register 1 bit 1
.equ	GPIOR12	= 2	; General Purpose I/O Register 1 bit 2
.equ	GPIOR13	= 3	; General Purpose I/O Register 1 bit 3
.equ	GPIOR14	= 4	; General Purpose I/O Register 1 bit 4
.equ	GPIOR15	= 5	; General Purpose I/O Register 1 bit 5
.equ	GPIOR16	= 6	; General Purpose I/O Register 1 bit 6
.equ	GPIOR17	= 7	; General Purpose I/O Register 1 bit 7

; GPIOR0 - General Purpose I/O Register 0
.equ	GPIOR00	= 0	; General Purpose I/O Register 0 bit 0
.equ	GPIOR01	= 1	; General Purpose I/O Register 0 bit 1
.equ	GPIOR02	= 2	; General Purpose I/O Register 0 bit 2
.equ	GPIOR03	= 3	; General Purpose I/O Register 0 bit 3
.equ	GPIOR04	= 4	; General Purpose I/O Register 0 bit 4
.equ	GPIOR05	= 5	; General Purpose I/O Register 0 bit 5
.equ	GPIOR06	= 6	; General Purpose I/O Register 0 bit 6
.equ	GPIOR07	= 7	; General Purpose I/O Register 0 bit 7

; PRR - Power reduction register
.equ	PRUSART	= 0	; 
.equ	PRUSI	= 1	; 
.equ	PRTIM0	= 2	; 
.equ	PRTIM1	= 3	; 

; BODCR - BOD control register
.equ	BPDSE	= 0	; 
.equ	BPDS	= 1	; 



; ***** LOCKSBITS ********************************************************
.equ	LB1	= 0	; Lockbit
.equ	LB2	= 1	; Lockbit


; ***** FUSES ************************************************************
; LOW fuse bits
.equ	CKSEL0	= 0	; Select Clock Source
.equ	CKSEL1	= 1	; Select Clock Source
.equ	CKSEL2	= 2	; Select Clock Source
.equ	CKSEL3	= 3	; Select Clock Source
.equ	SUT0	= 4	; Select start-up time
.equ	SUT1	= 5	; Select start-up time
.equ	CKOUT	= 6	; Clock output
.equ	CKDIV8	= 7	; Divide clock by 8

; HIGH fuse bits
.equ	BODLEVEL0	= 0	; Brown-out Detector trigger level
.equ	BODLEVEL1	= 1	; Brown-out Detector trigger level
.equ	BODLEVEL2	= 2	; Brown-out Detector trigger level
.equ	EESAVE	= 3	; EEPROM memory is preserved through chip erase
.equ	WDTON	= 4	; Watchdog Timer Always On
.equ	SPIEN	= 5	; Enable Serial programming and Data Downloading
.equ	DWEN	= 6	; debugWIRE Enable
.equ	RSTDISBL	= 7	; External reset disable

; EXTENDED fuse bits
.equ	SELFPRGEN	= 0	; Self Programming Enable



; ***** CPU REGISTER DEFINITIONS *****************************************
.def	XH	= r27
.def	XL	= r26
.def	YH	= r29
.def	YL	= r28
.def	ZH	= r31
.def	ZL	= r30



; ***** DATA MEMORY DECLARATIONS *****************************************
.equ	FLASHEND	= 0x03ff	; Note: Word address
.equ	IOEND	= 0x003f
.equ	SRAM_START	= 0x0060
.equ	SRAM_SIZE	= 128
.equ	RAMEND	= 0x00df
.equ	XRAMEND	= 0x0000
.equ	E2END	= 0x007f
.equ	EEPROMEND	= 0x007f
.equ	EEADRBITS	= 7
#pragma AVRPART MEMORY PROG_FLASH 2048
#pragma AVRPART MEMORY EEPROM 128
#pragma AVRPART MEMORY INT_SRAM SIZE 128
#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60



; ***** BOOTLOADER DECLARATIONS ******************************************
.equ	NRWW_START_ADDR	= 0x0
.equ	NRWW_STOP_ADDR	= 0x3ff
.equ	RWW_START_ADDR	= 0x0
.equ	RWW_STOP_ADDR	= 0x0
.equ	PAGESIZE	= 16



; ***** INTERRUPT VECTORS ************************************************
.equ	INT0addr	= 0x0001	; External Interrupt Request 0
.equ	INT1addr	= 0x0002	; External Interrupt Request 1
.equ	ICP1addr	= 0x0003	; Timer/Counter1 Capture Event
.equ	OC1Aaddr	= 0x0004	; Timer/Counter1 Compare Match A
.equ	OC1addr	= 0x0004	; For compatibility
.equ	OVF1addr	= 0x0005	; Timer/Counter1 Overflow
.equ	OVF0addr	= 0x0006	; Timer/Counter0 Overflow
.equ	URXCaddr	= 0x0007	; USART, Rx Complete
.equ	URXC0addr	= 0x0007	; For compatibility
.equ	UDREaddr	= 0x0008	; USART Data Register Empty
.equ	UDRE0addr	= 0x0008	; For compatibility
.equ	UTXCaddr	= 0x0009	; USART, Tx Complete
.equ	UTXC0addr	= 0x0009	; For compatibility
.equ	ACIaddr	= 0x000a	; Analog Comparator
.equ	PCIBaddr	= 0x000b	; Pin Change Interrupt Request B
.equ	PCIaddr	= 0x000b	; For compatibility
.equ	OC1Baddr	= 0x000c	; 
.equ	OC0Aaddr	= 0x000d	; 
.equ	OC0Baddr	= 0x000e	; 
.equ	USI_STARTaddr	= 0x000f	; USI Start Condition
.equ	USI_OVFaddr	= 0x0010	; USI Overflow
.equ	ERDYaddr	= 0x0011	; 
.equ	WDTaddr	= 0x0012	; Watchdog Timer Overflow
.equ	PCIAaddr	= 0x0013	; Pin Change Interrupt Request A
.equ	PCIDaddr	= 0x0014	; Pin Change Interrupt Request D

.equ	INT_VECTORS_SIZE	= 21	; size in words

#endif  /* _TN2313ADEF_INC_ */

; ***** END OF FILE ******************************************************
/*
 * hr_avr.asm
 *  Created: 30.06.2018 10:12:37
 *   Author: Lihouzov Evgeny
 */
 
//=========================    ======================================
rjmp   load_cfg;
//-- Interrupt --
; ***** INTERRUPT VECTORS ************************************************
reti                     ;0x0001 External Interrupt Request 0  (iINT0addr)
reti                     ;0x0002 External Interrupt Request 1  (iINT1addr)
reti                     ;0x0003 Timer/Counter1 Capture Event  (iICP1addr)
reti                     ;0x0004 Timer/Counter1 Compare Match A  (iOC1Aaddr)
reti                     ;0x0005 Timer/Counter1 Overflow  (iOVF1addr)
rjmp iOVF0addr           ;0x0006 Timer/Counter0 Overflow
reti                     ;0x0007 USART, Rx Complete  (iURXCaddr)
reti                     ;0x0008 USART Data Register Empty  (iUDREaddr)
reti                     ;0x0009 USART, Tx Complete  (iUTXCaddr)
reti                     ;0x000a Analog Comparator  (iACIaddr)
reti                     ;0x000b Pin Change Interrupt Request B  (iPCIBaddr)
reti                     ;0x000c   (iOC1Baddr)
reti                     ;0x000d   (iOC0Aaddr)
reti                     ;0x000e   (iOC0Baddr)
reti                     ;0x000f USI Start Condition  (iUSI_STARTaddr)
reti                     ;0x0010 USI Overflow  (iUSI_OVFaddr)
reti                     ;0x0011   (iERDYaddr)
reti                     ;0x0012 Watchdog Timer Overflow  (iWDTaddr)
reti                     ;0x0013 Pin Change Interrupt Request A  (iPCIAaddr)
reti                     ;0x0014 Pin Change Interrupt Request D  (iPCIDaddr)
;****	INT_VECTORS_SIZE	= 21	; size in word     ****
;****   Vector count = 21 ****
;****   Vector size  = 21 ****
.org INT_VECTORS_SIZE

// 
  .def  Addr_Data       = r0   //  (   )
  .def  Kern_A          = r1   //     
  .def  Zero            = r2   //    !!!
  .def  One             = r3   //    !!!
  .def  Uzel_Count      = r4   //    
  .def  FBD_size        = r5   //  FBD 
  .def  FBD_mem         = r6   //   

  .def  Uz1L            = r7   // 
  .def  Uz1H            = r8   // 
  .def  Uz2L            = r9   // 
  .def  Uz2H            = r10  // 
  .def  Uz3L            = r11  // 
  .def  Uz3H            = r12  // 
  .def  A               = r16  //   
  .def  B               = r17  //   
  .def  C               = r18   //   
  .def  D               = r19  //   
  .def  E               = r20  //   
  .def  F               = r21  //   
  .def  G               = r22  //   
  .def  H               = r23  //   

  .def  iA              = r24  //    
  .def  iB              = r25  //    

//  .def	Adr_RAM_H	    = r27  //        XH
//  .def	Adr_RAM_L	    = r26  //        XL
//  .def	Adr_EEPROM_H	= r29  //      YH
//  .def	Adr_EEPROM_L	= r28  //      YL
//  .def	Adr_flash_H	    = r31                                        ZH
//  .def	Adr_flash_L	    = r30                                        ZL


.MACRO    UOUT               //UOUT  "MEMORY MAPPED"   out 
.if	@0 < 0x40
      	out	@0,@1         
.else
      	sts	@0,@1
.endif
.ENDMACRO

.MACRO    UIN               //UIN  "MEMORY MAPPED"   in 
.if	@1 < 0x40
      	in	@0,@1         
.else
      	lds	@0,@1
.endif
.ENDMACRO

.MACRO    USBI               //USBI  "MEMORY MAPPED"   sbi 
.if	@0 < 0x40
      	sbi	@0,@1         
.else
      	lds	H,@0
        ori     H, 1 << @1
        sts     @0, H 
.endif
.ENDMACRO

.MACRO    UCBI               //UCBI  "MEMORY MAPPED"   cbi 
.if	@0 < 0x40
      	cbi	@0,@1         
.else
      	lds	H,@0
        cbr     H,@1
        sts     @0, H 
.endif
.ENDMACRO

.MACRO    USBIC               //USBIC  "MEMORY MAPPED"   sbic 
.if	@0 < 0x40
      	sbic 	@0,@1         
.else
      	lds	H,@0
        sbrc    H,@1
.endif
.ENDMACRO

.SET FBD_DATA_RAM = SRAM_START  //   FBD    
//-- Include --
//************************************************ FBD ****************************************************
#ifndef _FBD0_
#define _FBD0_ FBD0
#message define FBD0 __FILE__

FBD0_init:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 in    D, DDRD                                    ; 
 or    D, A                                       ; 
 sbrs  Addr_Data, 3                               ;
 eor   D, A                                       ; 
 out   DDRD, D                                    ;

 in    D, PORTD                                   ;  
 or    D, A                                       ; 
 sbrs  Addr_Data, 4                               ;
 eor   D, A                                       ; 
 out   PORTD, D                                   ;

 rcall Read_cfg                                   ;  
 ret;

FBD0_run:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 sbrc  Addr_Data, 3                               ;  
 rjmp  FBD0_Out_Pin                               ;

 clr   Uz1L;
 clr   Uz1H;
 in    D, PIND                                    ;  
 and   A, D                                       ; 
 cpse  A, Zero
 inc   Uz1L
 rcall Read_cfg_Save_Uz1                          ;
 ret;

FBD0_Out_Pin: 
 rcall Read_cfg_Load_Uz1                          ; 
 in    D, PORTD                                   ;  
 or    D, A                                       ; 
 sbrs  Uz1L, 0                                    ;
 eor   D, A                                       ; 
 out   PORTD, D                                   ;
 ret;

#else 
 #error redeclared FBD0 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD1_
#define _FBD1_ FBD1
#message define FBD1 Countert milliseconds (Timer 0)

#ifdef _Timer0_
#error redeclared Timer0 __FILE__
#endif
#define _Timer0_

.SET TimerCounter0_DATA_SIZE = 6
.SET TimerCounter0_DATA_RAM = FBD_DATA_RAM                               //   TimerCounter0
.SET FBD_DATA_RAM = TimerCounter0_DATA_RAM + TimerCounter0_DATA_SIZE     //   TimerCounter0
// :
//  1  - TCNT0
//  1  - TIMSK

iOVF0addr:  ;  
 LDS iB, TimerCounter0_DATA_RAM+5             ;  
 out TCNT0, iB                                ;  
 in  iB, SREG                                 ;                                     
 LDS iA, TimerCounter0_DATA_RAM               ;   
 add iA, One                                  ;   
 STS TimerCounter0_DATA_RAM, iA               ;   
 out SREG, iB                                 ;    
 reti

FBD1_init:
 rcall Read_cfg                                ; 
 STS   TimerCounter0_DATA_RAM+5, Addr_Data     ;   
 rcall Read_cfg                                ;  


#if defined( _TN13ADEF_INC_)||defined(_TN13DEF_INC_)||defined(_TN25DEF_INC_)||defined(_TN45DEF_INC_)||defined(_TN85DEF_INC_)||defined(_M328PDEF_INC_)
.equ _TCCR0=TCCR0B
#else
.equ _TCCR0=TCCR0
#endif

#if defined( _TN13ADEF_INC_)||defined(_TN13DEF_INC_)||defined(_M328PDEF_INC_)
.equ _TIMSK=TIMSK0
#else
.equ _TIMSK=TIMSK
#endif
 
 out _TCCR0, Addr_Data                          ;                                   
 UIN    A,      _TIMSK                         ;      !!!
 ori   A,     1<<TOIE0                         ;   
 UOUT   _TIMSK,  A                             ;   

 ret;

FBD1_run:
 ADIW  YL, 2                       ;  
 cli                               ; 
 LDS A, TimerCounter0_DATA_RAM     ;   
 STS TimerCounter0_DATA_RAM, Zero  ;   , 
 sei                               ; 
 LDS B, TimerCounter0_DATA_RAM+1   ;  
 add B, A                          ;  
 STS TimerCounter0_DATA_RAM+1, B   ;  
 LDS B, TimerCounter0_DATA_RAM+2   ;  
 adc B, Zero                       ;  
 STS TimerCounter0_DATA_RAM+2, B   ;  
 LDS B, TimerCounter0_DATA_RAM+3   ;  
 adc B, Zero                       ;  
 STS TimerCounter0_DATA_RAM+3, B   ;  
 LDS B, TimerCounter0_DATA_RAM+4   ;  
 adc B, Zero                       ;  
 STS TimerCounter0_DATA_RAM+4, B   ;  
 ret;



Timer_Diff:
  lds  ZL, TimerCounter0_DATA_RAM+1       // Lw
  lds  ZH, TimerCounter0_DATA_RAM+2       // Hg
  sub  ZL, Uz1L                           // 
  sbc  ZH, Uz1H                           // 
//  brcc Timer_Diff_end
//  neg  ZL                                 // 
//  com  ZH                                 // 
//Timer_Diff_end:   
  ret 

#else 
 #error redeclared FBD1 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD2_
#define _FBD2_ FBD2
#message define FBD2 (generator impulse)__FILE__

//  FDB  4 
//1 - 
//2   
//1 - 
//  2 
//2 

FBD2_run:
//===========   FDB  =========== 
 rcall Read_Cfg_Load_Uz1    //  
 rcall Read_cfg             //  Lw
 mov   C, Addr_Data         //  Lw  
 rcall Read_cfg             //  Hg
 mov   D, Addr_Data         //  Hg
 ld    ZL, X+               //  Lw
 ld    ZH, X+               //  Hg
 sbiw  XL, 2                // 
//=============   FBD  =============== 
 and  Uz1L, One             //and
 brne FBD2_One              //

  mov   ZL, Zero            // 
  mov   ZH, Zero            // 
  rjmp  FBD2_Next           //

FBD2_One:                   //  1
 adiw ZL, 1                 // 
 brcc FBD2_no_max           // 
 sbiw ZL, 1                 //
FBD2_no_max:
  cpse  ZL, C               //
  clr   Uz1L                // 
  cpse  ZH, D               //
  clr   Uz1L                // 

FBD2_Next:
//=============    ==================  
  st    X+, ZL              // 
  st    X+, ZH              // 
  rcall Read_cfg_Save_Uz1   // 
 ret

#else 
 #error redeclared FBD2 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD3_
#define _FBD3_ FBD3
#message define FBD3 time off
; FBD 
;1   -
;2  -
;1   -
; :
;  1   - 
;  2  -  

FBD3_run:
  ld    A,    X+                                   ;  
  ld    Uz1L, X+                                   ;  Lw
  ld    Uz1H, X+                                   ;  Hw
  sbiw  XL,   3                                    ; 

  rcall Read_cfg_Load_Uz2                          ;
  rcall Read_cfg                                   ;   Lw
  mov   C, Addr_Data                               ;   Lw
  rcall Read_cfg                                   ;   Hg
  mov   D, Addr_Data                               ;   Hg
  mov Uz3L, Zero                                   ;  "0"
//*****************   **********************
  sbrc Uz2L, 0
  rjmp FBD3_start
//***********    **********************
  tst  A                     //  ( )
  brpl FBD3_end             //  ( ) 
//*************    *************************
  rcall Timer_Diff           //  
  cp   ZL,  C                //
  cpc  ZH,  D                //
  brmi FBD3_one
  andi A, 0b01111111         //(   )

FBD3_end:
  st   X+,   A               //
  st   X+,   Uz1L            //
  st   X+,   Uz1H            //
  rcall Read_cfg_Save_Uz3    // 
  ret

FBD3_start:
  mov  Uz3L, One                            // 1
  ori  A,   0b10000000                      //(   )
  lds  Uz1L, TimerCounter0_DATA_RAM+1       //  
  lds  Uz1H, TimerCounter0_DATA_RAM+2       //  
  rjmp FBD3_end                            //

FBD3_one:
  mov  Uz3L, One               // 1
  rjmp FBD3_end



#else 
 #error redeclared FBD3 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD4_
#define _FBD4_ FBD4
#message define FBD4 (NOT)__FILE__

//  FDB  3 
//1 - 
//1 - 
//   

FBD4_run:
//========       ========= 
 rcall Read_cfg_Load_Uz1                                   ; 
//=============   FBD  ==================
// ldi  A, 0b00000001                               ;
 com  Uz1L                                        ;
 and  Uz1L, One                                     ;and
//=============    ==================
 clr   Uz1H                                       ; 
 rcall Read_cfg_Save_Uz1                                   ; 
 ret;

#else 
 #error redeclared FBD4 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD5_
#define _FBD5_ FBD5
#message define FBD5 (Generators) __FILE__

//  FDB  5 
//1 -   
//2 -   
//2 -   
//1 -   (  )
//2 -    
//   
//1 -   (  )
//2 -    
FBD5_init:     
 ADIW  YL, 5                                      ;    
 rcall Read_cfg                                   ;  
 st    X+, Addr_Data                              ;  
 rcall Read_cfg                                   ;   
 st    X+, Addr_Data                              ;     Lw
 rcall Read_cfg                                   ;        Lw
 st    X+, Addr_Data                              ;    Hg
 ret                                              ;         Hg

FBD5_run:
//========       ========= 
 rcall Read_cfg                                     ;  
 mov   B, Addr_Data                               ;  
 rcall Read_cfg                                     ;  
 mov   C, Addr_Data                               ;   Lw
 rcall Read_cfg                                     ;  
 mov   D, Addr_Data                               ;   Hg

 rcall Read_cfg                                     ;  
 mov   E, Addr_Data                               ;    Lw
 rcall Read_cfg                                     ;  
 mov   F, Addr_Data                               ;    Hg
 ADIW  YL, 3                                      ;   
//=========       =========
 ld    G,  X+                                     ; 
 ld    ZL, X+                                     ;    Lw
 ld    ZH, X+                                     ;    Hw
//=============   FBD  ==================
 adiw  ZL, 1                                      ;   
 breq  FBD5_change_sost                           ; 
 cp   ZL, C                                       ;    
 cpc  ZH, D                                       ;    
 sbrs G, 0                                        ; 
 cp   ZL, E                                       ;    
 sbrs G, 0                                        ; 
 cpc  ZH, F                                       ;    
 brsh  FBD5_change_sost                           ; 
 SBIW  XL, 2                                      ;   
 st   X+, ZL                                      ;  
 st   X+, ZH                                      ;  
 rjmp  FBD5_run_end;                              ;
FBD5_change_sost:
 inc   G                                          ; 
 andi  G,  0b00000001                             ; 
 clr   ZL                                         ;   
 clr   ZH                                         ;   
 SBIW  XL, 3                                      ;   
 st   X+, G                                       ;  
 st   X+, ZL                                      ;  
 st   X+, ZH                                      ;  
FBD5_run_end:
 clr   Uz1H                                       ;   
 mov   Uz1L, G                                    ;   
 mov   Addr_Data, B   
 rcall Save_Uz1                                   ;     B
 ret                                              ;   
#else 
 #error redeclared FBD5 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD6_
#define _FBD6_ FBD6
#message define FBD6 (AND)__FILE__

//  FDB  3 
//1 -  1
//1 -  2
//1 - 
//   

FBD6_run:
//========       ========= 
 rcall Read_cfg_Load_Uz1                                   ; 1 
 rcall Read_cfg_Load_Uz2                                   ; 2 
//=============   FBD  ==================
 //ldi  A, 0b00000001                               ;
 and  Uz1L, Uz2L                                  ;and
 and  Uz1L, One                                     ;and
//=============    ==================
 clr  Uz1H                                        ; 
 rcall Read_cfg_Save_Uz1                                   ; 
 ret;

#else 
 #error redeclared FBD6 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD7_
#define _FBD7_ FBD7
#message define FBD7 time CTN
; FBD 
;1   - U ()
;1   - D ()
;1   - R ()
;1   - N ()
;1   - Q ()
;2  -  
; :
;  1   -   U, D ( 7,6)
;  2  -  

FBD7_init:     
 ADIW  YL, 5                                      ;    
 ldi   A, 0b11000000                              ;  
 st    X+, Addr_Data                              ;   
 rcall Read_cfg                                   ;   
 st    X+, Addr_Data                              ;     Lw
 rcall Read_cfg                                   ;      
 st    X+, Addr_Data                              ;    Hg
 ret                                              ;        

FBD7_run:
//*************    *******************
  ld    A,    X+                                   ;  
  ld    Uz3L, X+                                   ;  Lw
  ld    Uz3H, X+                                   ;  Hw
//*************    *********************
  rcall Read_cfg_Load_Uz1                          ; U
  rcall Read_cfg_Load_Uz2                          ; D
//*****************   U ********************
  bst  A, 7
  sbrs Uz1L, 0
  rjmp FBD7_no_U
  brts FBD7_no_U
  add  Uz3L, One         //  +1
  adc  Uz3H, Zero
  rjmp FBD7_no_D
//*****************   D ********************
FBD7_no_U:
  bst  A, 6
  sbrs Uz2L, 0
  rjmp FBD7_no_D
  brts FBD7_no_D
  sub  Uz3L, One         //  -1
  sbc  Uz3H, Zero
FBD7_no_D:
//***********    ********************
  bst  Uz1L, 0
  bld  A, 7              //  U
  bst  Uz2L, 0
  bld  A, 6              //  D
//*************    *********************
  rcall Read_cfg_Load_Uz1                          ; R
  rcall Read_cfg_Load_Uz2                          ; N
//*****************   R *********************
  sbrs Uz1L, 0
  rjmp FBD7_end
  mov  Uz3L, Uz2L
  mov  Uz3H, Uz2H
FBD7_end:
  SBIW  XL,  3               //   
  st   X+,   A               //
  st   X+,   Uz3L            //
  st   X+,   Uz3H            //
  rcall Read_cfg_Save_Uz3    // 
  ADIW  YL,  2               //  
  ret 



#else 
 #error redeclared FBD7 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD8_
#define _FBD8_ FBD8
#message define FBD8 __FILE__

FBD8_init:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 in    D, DDRB                                    ; 
 or    D, A                                       ; 
 sbrs  Addr_Data, 3                               ;
 eor   D, A                                       ; 
 out   DDRB, D                                    ;

 in    D, PORTB                                   ;  
 or    D, A                                       ; 
 sbrs  Addr_Data, 4                               ;
 eor   D, A                                       ; 
 out   PORTB, D                                   ;

 rcall Read_cfg                                   ;  
 ret;

FBD8_run:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 sbrc  Addr_Data, 3                               ;  
 rjmp  FBD8_Out_Pin                               ;

 clr   Uz1L;
 clr   Uz1H;
 in    D, PINB                                    ;  
 and   A, D                                       ; 
 cpse  A, Zero
 inc   Uz1L
 rcall Read_cfg_Save_Uz1                          ;
 ret;

FBD8_Out_Pin: 
 rcall Read_cfg_Load_Uz1                          ; 
 in    D, PORTB                                   ;  
 or    D, A                                       ; 
 sbrs  Uz1L, 0                                    ;
 eor   D, A                                       ; 
 out   PORTB, D                                   ;
 ret;

#else 
 #error redeclared FBD8 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD9_
#define _FBD9_ FBD9
#message define FBD9 (integer more)__FILE__

//  FDB  3 
//1 -  1
//1 -  2
//1 - 
//   

FBD9_run:
//========       ========= 
 rcall Read_cfg_Load_Uz1                                   ; 1 
 rcall Read_cfg_Load_Uz2                                   ; 2 
//=============   FBD  ==================
 clr  Uz3H                            ; 
 clr  Uz3L                            ; 
 cp   Uz2L, Uz1L                      ;
 cpc  Uz2H, Uz1H                      ;
 brcc FBD9_zero
 inc  Uz3L                            ;Uz1>Uz2
FBD9_zero:
//=============    ==================
 rcall Read_cfg_Save_Uz3                                   ; 
 ret;

#else 
 #error redeclared FBD9 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD10_
#define _FBD10_ FBD10
#message define FBD10 (OR)__FILE__

//  FDB  3 
//1 -  1
//1 -  2
//1 - 
//   

FBD10_run:
//========       ========= 
// rcall Read_cfg                                     ; 1
 rcall Read_cfg_Load_Uz1                                   ; 1 
// rcall Read_cfg                                     ; 2
 rcall Read_cfg_Load_Uz2                                   ; 2 
//=============   FBD  ==================
// ldi  A, 0b00000001                               ;
 or   Uz1L, Uz2L                                    ;or
 and  Uz1L, One                                     ;and
//=============    ==================
 clr  Uz1H                                        ; 
// rcall Read_cfg                                     ; 
 rcall Read_cfg_Save_Uz1                                   ; 
 ret;

#else 
 #error redeclared FBD10 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD11_
#define _FBD11_ FBD11
#message define FBD11 time on
; FBD 
;1   -
;2  -
;1   -
; :
;  1   - 
;  2  -  

FBD11_run:
  ld    A,    X+                                   ;  
  ld    Uz1L, X+                                   ;  Lw
  ld    Uz1H, X+                                   ;  Hw
  sbiw  XL,   3                                    ; 

  rcall Read_cfg_Load_Uz2                          ;
  rcall Read_cfg                                   ;   Lw
  mov   C, Addr_Data                               ;   Lw
  rcall Read_cfg                                   ;   Hg
  mov   D, Addr_Data                               ;   Hg

//*****************   **********************
  sbrs Uz2L, 0
  rjmp FBD11_clear
//***********    **********************
  tst  A                     //  ( )
  brpl FBD11_start           //  ( ) 
//*************    *************************
  rcall Timer_Diff           //  
  cp   ZL,  C                //
  cpc  ZH,  D                //
  brmi FBD11_set_zero
  mov Uz3L, One              // 1

FBD11_end:
  st   X+,   A               //
  st   X+,   Uz1L            //
  st   X+,   Uz1H            //
  rcall Read_cfg_Save_Uz3    // 
  ret

FBD11_start:
  ori  A,   0b10000000                     //(   )
  lds Uz1L, TimerCounter0_DATA_RAM+1       //  
  lds Uz1H, TimerCounter0_DATA_RAM+2       //  

FBD11_set_zero:
  mov  Uz3L, Zero              // 0
  rjmp FBD11_end

FBD11_clear:
  andi A, 0b01111111           //(   )
  mov  Uz3L, Zero              // 0
  rjmp FBD11_end



#else 
 #error redeclared FBD11 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD12_
#define _FBD12_ FBD12
#message define FBD12 (RS trigger)__FILE__

//  FDB  4 
//1 -  S
//1 -  R
//1 - 
//1 -  
//  1 
//1   

FBD12_init:     
 ADIW  YL, 3                        //    
 rcall Read_cfg                     //  
 st    X+, Addr_Data                //  
 ret                                //  

FBD12_run:
//========    ========= 
 rcall Read_cfg_Load_Uz1           // S 
 rcall Read_cfg_Load_Uz2           // R 
 ld    A,  X                       //  
//=============   FBD  ==================
 mov  Uz3L, A                      //  
 and  Uz1L, One                    //and
 sbrc UZ1L, 0                      // 1  S
 mov  A, One                       // 
 and  Uz2L, One                    //and
 sbrc UZ2L, 0                      // 1  R
 mov  A, Zero                      // 
 //mov  Uz1L, A                      //  
//=============    ==================
 st X+, A
 rcall Read_cfg_Save_Uz3           // 
 ADIW  YL, 1                       //  
ret;

#else 
 #error redeclared FBD12 __FILE__
#endif
//********************************************************************************************************
//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_real.inc   =====================================
/*
 *  library of real numbers version 1.1
 *
 *  Created: 06.01.2014
 *  Author: Lihouzov Evgeny
 */

#ifdef _real_add_sub_fun_
#define _lib_real_
#endif

#ifdef _real_mul_fun_
#define _lib_real_
#endif

#ifdef _real_div_fun_
#define _lib_real_
#endif

#ifdef _real_Int16ToReal_fun_
#define _lib_real_
#endif

#ifdef _lib_real_
#message define Include library for real numbers in __FILE__

//  
Read_Cfg_Load_Pointer_Z:
     rcall Read_cfg                  //  
     rcall Set_Adres_Uzl             //  Z   
     ld    Addr_Data,  Z+            // 
     ld    ZH, Z                     // 
     mov   ZL, Addr_Data             // 
     ret

// ABCD 
Read_Cfg_Load_ABCD:
 rcall Read_Cfg_Load_Pointer_Z   // 
     ld  D, Z+                       // 
     ld  C, Z+                       // 
     ld  B, Z+                       // 
     ld  A, Z+                       // 
     ret

// EFGH 
Read_Cfg_Load_EFGH:
 rcall Read_Cfg_Load_Pointer_Z   // 
     ld  H, Z+                       // 
     ld  G, Z+                       // 
     ld  F, Z+                       // 
     ld  E, Z+                       // 
     ret

//   ABCD    
lib_real_rec: 
     lsl B       //     
     rol A       //  
     lsr B       //   
     ori B, 0x80 //  1  
     ret 

//     T  
lib_real_pack: 
    lsl  B     //    
    lsr  A     //  
    ror  B     //   
    bld  A, 7  // 
    ret 

//  
lib_real_swap_ABCD_EFGH: 
    eor A, E   //  A, E
    eor E, A 
    eor A, E 
    eor B, F   //  B, F
    eor F, B 
    eor B, F 
    eor C, G   //  C, G
    eor G, C 
    eor C, G 
    eor D, H   //  D, H
    eor H, D 
    eor D, H 
    ret
 
//C BCD  0 
lib_real_cp_ABCD_0: 
    mov ZL, A 
    or  ZL, B 
    or  ZL, C 
    or  ZL, D // BCD=0   Z=l 
    ret        

//C EFGH  0
lib_real_cp_EFGH_0: 
    mov ZL, E 
    or  ZL, F 
    or  ZL, G 
    or  ZL, H // BCD=0   Z=l 
    ret   

//  24-   ABCD
lib_real_shift_ABCD: 
    lsr B 
    ror C 
    ror D 
    clc 
    ret 

// ABCD (ABCD=0)
lib_real_clear_ABCD: 
    clr A 
    clr B 
    clr C 
    clr D 
    ret 

#endif


#ifdef _real_add_sub_fun_
#message Include AddF function in __FILE__
#message Include SubF function in __FILE__

//*****         *****// 
real_AddF:                        //  
    mov ZL, A                     // 
    eor ZL, E                     // 
    brpl real_AddFl               // 
    subi E, 0x80                  // 
    rjmp real_SubF                //  

real_AddFl: 
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    breq real_AddF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0 
    brne real_AddF2               // 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    ret                           // 

real_AddF2: 
    bst  A, 7                     //  T=A.7 
    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
    mov ZL, A                     //  
    sub ZL, E                     //           
    brpl real_AddF3               //,   ABCD>EFGH 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    mov ZL, A                     //  
    sub ZL, E                     //    

real_AddF3: 
    breq real_AddF6               //,     
    cpi ZL,24                     // c   24 
    brmi real_AddF4               // 
    rjmp real_AddF7               //    

real_AddF4: 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH  

real_AddF5: 
    rcall lib_real_shift_ABCD     //   ABCD 
    inc A                         //    
    dec ZL                        //   
    brne real_AddF5 

real_AddF6: 
    add D, H                      //  
    adc C, G                      // 
    adc B, F                      // 
    brcc real_AddF7               //   
    inc A                         //  
    breq real_AddF_Quit           //    ( C)
    rcall lib_real_shift_ABCD     //   ABCD 

real_AddF7: 
    rcall lib_real_pack           // 
real_AddF_Quit:
    ret                           // 

//==============================================================//
real_SubF:                        //  
    mov ZL, A                     // 
    eor ZL, E                     // 
    brpl real_SubFl               //   
    subi E, 0x80                  //  2-       
    rjmp real_AddF                //   

real_SubFl: 
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    breq real_SubF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    brne real_SubF2               // 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH  
    subi A, 0x80                  //  1-  
    ret                           // 

real_SubF2: 
    bst  A, 7                     //  T=A.7 
    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
    mov ZL, E                     //  
    sub ZL, A                     //           
    brne real_SubF3               //,   
    cp F, B                       // 
    brne real_SubF3               //,    
    cp G, C                       // 
    brne real_SubF3               //,   
    cp H, D                       // 
    brne real_SubF3               //,   
    rcall lib_real_clear_ABCD     //  ABCD=0
    ret                           // 
 
real_SubF3: 
    brcc real_SubF4               //,  1-   
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH  
    bld  ZL, 7                    //   
    subi ZL, 0x80                 //   
    bst  ZL, 7                    //   
 
real_SubF4: 
    mov ZL, E                     //   
    sub ZL, A                     //  
    breq real_SubF7               //    
    cpi ZL, 24                    // c   24 
    brmi real_SubF6               //  
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rjmp real_SubF9               // 
 
real_SubF6:
    rcall lib_real_shift_ABCD     //   ABCD 
    dec ZL                        //   
    brne real_SubF6               //      
    
real_SubF7: 
    sub H, D                      // 
    mov D, H                      // EFGH->ABCD
    sbc G, C                      //    
    mov C, G                      // EFGH->ABCD 
    sbc F, B                      //    
    mov B, F                      // EFGH->ABCD                  
    mov A, E                      // EFGH->ABCD 

real_SubF8: 
    sbrc B, 7                     //   
    rjmp real_SubF9               //,   , 
    dec A                         //,   , 
    cpi A, 0xFF                   // , 
    sec                           //    1, 
    breq real_SubF_Quit           //     C=1 
    lsl D                         //  ABCD  
    rol C                         //  ABCD 
    rol B                         //  ABCD 
    clc                           //  C=0
    rjmp real_SubF8               // 
 
real_SubF9: 
    rcall lib_real_pack           // 
real_SubF_Quit: 
    ret                           //    

#endif

#ifdef _real_mul_fun_
#message Include mulF function in __FILE__
real_MulF:
    clr Uz1L                      //   
    clr Uz1H                      //  
    clr Uz2L                      //  
    clr Uz2H                      //  
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    breq real_MulF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    breq real_MulF_Quit           // 

    mov ZL, A                     //   
    eor ZL, E                     //  
    bst ZL, 7                     //    

    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
 
  //  mov  Uz1L, E                  //  
    add  A, E                     //  
    brcs real_MulFl 
    subi A, 127                   //   
    brcc real_MulF2 
    rjmp real_MulF_Quit
 
real_MulFl: 
    ldi ZL, 129                   //     
    add A,  ZL                    // -25+129=-127 
    brcs real_MulF_Quit           //
  
real_MulF2:                       //  (C=AxB)
    ldi ZL, 24                    //   
real_MulF3:
    ror F                         //  
    ror G                         //     
    ror H                         //
    brcc real_MulF4               //    1, 
    add Uz2H, D                   //  (L-), 
    adc Uz2L, C                   //  - 
    adc UZ1H, B                   //  - 

real_MulF4: 
    dec ZL                        //   
    brne real_MulF5               //  ,  
    rjmp real_MulF6 

real_MulF5:
    ror Uz1H                      //   
    ror Uz2L                      //  
    ror Uz2H                      //  
    rjmp real_MulF3 
 
real_MulF6:                       // 
    brcc real_MulF7               //  
    ror Uz1H                      //
    ror Uz2L                      //
    ror Uz2H                      //
    inc A                         //  
    sec                           //C=l 
    breq real_MulF_Quit           //    
real_MulF7:  
    mov D, Uz2H                   //
    mov C, Uz2L                   //
    mov B, Uz1H                   //
//    mov A, Uz1L                   // 
    rcall lib_real_pack           // 

real_MulF_Quit: 
    ret                           //  

#endif

#ifdef _real_div_fun_
#message Include DivF function in __FILE__

real_DivF:
    clr Uz1L                      //   
    clr Uz1H                      //  
    clr Uz2L                      //  
    clr Uz2H                      //  
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    sec                           //C=1
    breq real_DivF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    clc                           //C=0
    breq real_DivF_Quit           // 

    mov ZL, A                     //   
    eor ZL, E                     //  
    bst ZL, 7                     //    

    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
    rcall lib_real_swap_ABCD_EFGH //     
 
    sub A, E                      //  
    brcc real_DivFl               //  
    ldi ZL, 127                   //  
    add A, ZL                     //
    brcs real_DivF2               //    
    sec                           // 
    rjmp real_DivF_Quit           //

real_DivFl: 
    ldi ZL, 127                   //   
    add A,  ZL                    //
    brcs real_DivF_Quit           //   
  
real_DivF2:                       //  (C=A/B)
    clr E                         //   
    ldi ZL, 24                    //   
real_DivF3: 
   // push mAL ;  mA 
   // push mAM ; ()   
   // push mAH 

    cp  D, H                      //
    cpc C, G                      //
    cpc B, F                      //
    cpc E, Zero

    brcc real_DivF4 
   // pop mAH /  
   // pop mAM ;" , .. mA<mB 
   // pop mAL                    //C=1
    clc                          //   0 
    rjmp real_DivF5 

real_DivF4:
    sub D, H                     //
    sbc C, G                     //
    sbc B, F                     //
    sbc E, Zero                  //
    sec                          //   1 

real_DivF5: 
    rol Uz2H                      //   
    rol Uz2L                      //  
    rol Uz1H                      //  
    clc 
    rol D                         //   
    rol C                         //  
    rol B                         //  
    rol E                         //  
    dec ZL                        //   
    brne real_DivF3               //,  ZL>0 
 
    sbrc Uz1H, 7                  // 
    rjmp real_DivF6               //  
    rol Uz2H                      // 
    rol Uz2L                      //   
    rol Uz1H                      //  
    dec A                         //   
    cpi A,0xFF 
    sec                           //C=1 
    breq real_DivF_Quit           //    
real_DivF6: 
   // mov , /  
    mov D, Uz2H                  // 
    mov C, Uz2L                  //
    mov B, Uz1H                  //
real_DivF7: 
    rcall lib_real_pack          //  
real_DivF_Quit: 
    ret                          //   

#endif


#ifdef _real_Int16ToReal_fun_
#message Include Int16ToReal function in __FILE__

real_Int16ToReal:                 // Int16(Uz1H,Uz1L)  . (ABCD)
    clr  A                        // 
    mov  B, Uz1H                  // 
    mov  C, Uz1L                  // 
    clr  D                        // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    breq real_Int16ToReal_Quit_2  // 
	ldi  A, 127+15                // 
    bst  B, 7                     //   
    brtc real_Int16ToReal1        // 
    com  B                        // 
    neg  C                        // 
real_Int16ToReal1: 
    sbrc B, 7                     //   
    rjmp real_Int16ToReal_Quit    //,   , 
    dec A                         //,   , 
    lsl D                         //  ABCD  
    rol C                         //  ABCD 
    rol B                         //  ABCD 
    clc                           //  C=0
    rjmp real_Int16ToReal1        // 
real_Int16ToReal_Quit: 
    rcall lib_real_pack           // 
real_Int16ToReal_Quit_2: 
    ret                           //   
#endif

//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_one_wire.inc   =====================================
/*
 *  library of one_wire version 1.1
 *
 *  Created: 28.04.2016
 *  Author: Lihouzov Evgeny
 */

#ifdef _lib_one_wire_
#message define Include library for one_wire in __FILE__
//==========  
//  C  -  
//  D  -  
//  E  -  
//  F  -  
//  G  - C   /  
//  H  -     
//  B  - CRC8                                                  
 rcall Read_cfg_Load_Uz1         // 
 mov ZL, Uz1L
 mov ZH, Uz1H
//  Uz1L -  FBD 
//  Uz1H -  FBD 
//  G    -  
//  Uz2H -  (0000X000)
//  Z    -    (PINC)

One_wire_begin:   //=======     =========
  BST One, 0                     //  
//=============================  ===========================  
  andi D, 0b11111111             // 
  breq One_wire_send_reset
  dec  D                         // 
  brne One_wire_pause_end
  tst  G
  breq One_wire_pause_end
  ldi  D, 255
  dec  G
One_wire_pause_end:
  ret
//================    ========================

//====================   ======================
One_wire_send_reset:
  cpi  C, 0x80
  brmi One_wire_send_byte
  ldi  A, 0b01000000
  and  A, C
  breq One_wire_reset_0
  rcall One_wire_cfg_in           //    
  rcall One_wire_set1             // 1
  ldi   d, 245                    //
  rcall One_wire_wait             //    90*10^-6  
  ld   A, Z                       //  
  and  A, Uz2H                    //  
  brne One_wire_error             //  
  andi C, 0b00111111              // 
  ldi   D, 2                      // 
  ret
One_wire_reset_0:
  rcall One_wire_cfg_out          //    
  rcall One_wire_set0             // 0
  ori   C, 0b01000000             //       
  ldi   D, 2                      //   
  ret 
//===================  /  =====================
One_wire_send_byte:
  cpi  E, 0
  breq One_wire_send_paket
  rcall One_wire_cfg_out
  rcall One_wire_set0
  mov A, F
  and A, E
  ldi D, 13                     //10*10^-6 
  brne One_wire_send_bit_next
  ldi D, 200                    //90*10^-6 
One_wire_send_bit_next:
  or  F, E                        // 
  eor F, E                        //   
  rcall One_wire_wait
  rcall One_wire_cfg_in
  rcall One_wire_set1
  ldi D, 1                        //  
  rcall One_wire_wait             //  
  or   F, E                       //  1
  mov  Addr_Data, One             // 1
  ld   A, Z                       //  
  and  A, Uz2H                    //  
  brne One_wire_send_bit_next2
  eor   F, E                      //  
  clr   Addr_Data                 // 0
One_wire_send_bit_next2: 
  rcall One_wire_CRC_8_calc_bit   //B-CRC8, Addr_Data (0b0000000X)-  , A-     
  lsl  E                          //    
  breq One_wire_save_recive_byte
  ret
One_wire_save_recive_byte:
  mov  A, ZL
  ldi  ZL, Low(DS18B20_DATA_RAM)  //  
  ldi  ZH, High(DS18B20_DATA_RAM) //  
  add  ZL, G
  adc  ZH, Zero
  st   -Z, F                      //  
  mov  ZL, A 
  clr  ZH
  ret
//==================   ==================
One_wire_send_paket:
  cpi  H, 0
  breq One_wire_end
  dec  H
  mov  A, ZL
  ldi  ZL, Low(DS18B20_DATA_RAM)  //  
  ldi  ZH, High(DS18B20_DATA_RAM) //  
  add  ZL, G
  adc  ZH, Zero
  ld   F, Z                       //  
  ldi  E, 0x01                    //  
  mov  ZL, A 
  clr  ZH
  inc  G
  ret
//==================  =============================== 
One_wire_error:
  ori D, 0x80      
One_wire_end:
  BST Zero, 0                    //  
  ret

//***************   *****************
One_wire_cfg_out:
 ldd  A, Z+1
 or   A, Uz2H
 std  Z+1, A
 ret  
One_wire_cfg_in:
 ldd  A, Z+1
 or   A, Uz2H
 eor  A, Uz2H
 std  Z+1, A
 ret 
                                        
One_wire_set1:
 ldd  A, Z+2
 or   A, Uz2H
 std  Z+2, A
 ret  

One_wire_set0:
 ldd  A, Z+2
 or   A, Uz2H
 eor  A, Uz2H
 std  Z+2, A
 ret 

One_wire_wait:
 dec  D
 brne One_wire_wait
 ret

;***************************************************************
;    (CRC-8)   
;  - Addr_Data 0b0000000X
;  - B -   CRC-8
;  - A, B 
;***************************************************************
One_wire_CRC_8_calc_bit:     //B-CRC8, Addr_Data (0b0000000X)-  , A-  
	//	clr		w1CRCtmp	   //    CRC
	//	bld		w1CRCtmp,0	   //  
		eor		Addr_Data, B	   //    
		ror		Addr_Data	   // - "0"  "1"
		mov		Addr_Data, B       //  
		brcc	One_wire_CRC_8_next        //  "0" - 
		ldi		A, $18  	   //  "1" -  
		eor		Addr_Data, A       //   
One_wire_CRC_8_next:
		ror		Addr_Data	   //     
		mov		B, Addr_Data	   //   
		ret

#endif
//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_modbus.inc   =====================================
/*
 *  library of modbus version 1.1
 *
 *  Created: 28.04.2015
 *  Author: Lihouzov Evgeny
 */

#ifdef _lib_modbus_
#message define Include library for modbus protocol in __FILE__

 //=== FIFO ,   ===
 //==  Z -   -
 //==  G -  -
 //==  H -  /   - 

//*********************************************************************
modbus_FIFO_write_buf:    //Z- G- H  ( E,F )
  ld   E, Z+            ; 
  ld   F, Z             ; 

  inc  F
  cp   F, G
  brne modbus_FIFO_write_buf_1
  clr  F
modbus_FIFO_write_buf_1:
  
  cp E, F                  ;
  brne modbus_FIFO_write_buf_2  ;
  set                      ;
  ret                      ;
modbus_FIFO_write_buf_2:

  mov E,   F
  ld  F,   Z
  st  Z+,  E

  add ZL, F
  adc ZH, Zero
  st  Z,  H           ;
  clt                 ;
  ret                 ;
//*********************************************************************
modbus_FIFO_read_buf:   //Z- G- H  ( E,F )
  ld   E, Z+            ; 
  ld   F, Z             ; 

  cp E, F                 ;
  brne modbus_FIFO_read_buf_1  ;
  set                     ;
  ret                     ;
modbus_FIFO_read_buf_1:

  mov  F, E
  inc  E
  cp   E, G
  brne modbus_FIFO_read_buf_2
  clr  E
modbus_FIFO_read_buf_2:
  
  st  -Z,  E
  adiw Z,  2

  add ZL, F
  adc ZH, Zero
  ld  H,  Z           ;
  clt                 ;
  ret                 ;
//*********************************************************************
modbus_line_write_buf:    //Z- G- H  ( F )
  ld   F, Z                ; 
  set                      ;
  cp   F, G
  breq modbus_line_write_buf_end
  mov  E, F                ; 
  inc  E                   ; 
  st   Z+, E               ; 
  add  ZL, F
  adc  ZH, Zero
  st   Z,  H               ;
  clt                      ;
modbus_line_write_buf_end:
  ret                 ;

//*********************************************************************
 //===  CRC 16   ===
 //==  Z -   
 //==  E -    CRC_16

modbus_CRC_16_calc:    //Z- E- ( A,B,D,E,F ) BA=_16
 ldi   A,  0b11111111             //  CRC_16
 ldi   B,  0b11111111             //  CRC_16
 ldi   D,  0b10100000             //  
modbus_CRC_16_Read_Byte:
 ld    F,  Z+                     //  
 eor   A,  F                      //  XOR
 LDI   F,  8                      //  
modbus_CRC_16_Loop_Bit:
 lsr B                            //   CRC 
 ror A                            //   CRC 
 brcc modbus_CRC_16_Next_Loop_Bit
 eor  B, D                        // CRC  
 eor  A, One                      // CRC  
modbus_CRC_16_Next_Loop_Bit:
 dec  F                           //  
 brne modbus_CRC_16_Loop_Bit      //  
 dec  E                           //  
 brne modbus_CRC_16_Read_Byte     //  
 ret    //===   BA=_16  ===

//*********************************************************************
 //===     ===
 //==  Z -   
 //==  A- 

modbus_run_comand:    //Z- A-  ( A,B,C,D,E,F ) BA=_16
  ld   E,  Z                 ; 
  st   Z+,  Zero             ;   
  cpi  E,  4                 ; 
  brcs modbus_run_comand_end ; 
  ld   F,  Z+                ; 
  cp   F,  A                 ; 
  brne modbus_run_comand_end ; 
  
  ld   C, Z+                 ;   
  mov  G, ZL                 ;   
  mov  H, ZH                 ;   
  sbiw ZL, 2                 ;   

  rjmp modbus_CRC_16_calc    ; CRC

  ld   F, Z+                 ; CRC
  cp   B, F                  ; CRC
  brne modbus_run_comand_end ; CRC

  ld   F, Z+                 ; CRC
  cp   A, F                  ; CRC
  brne modbus_run_comand_end ; CRC

  ldi  ZL, Low (modbus_function)
  ldi  ZL, Low (modbus_function)
  ijmp                       ; 

modbus_run_comand_end:
 ret  

//  
modbus_function:
 rjmp modbus_illegal_function      //1-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //2-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //3-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //4-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //5-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //6-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //7-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //8-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //9-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //10-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //11-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //12-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //13-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //14-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //15-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //16-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //17-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //18-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //19-READ COIL STATUS	      (ON/OFF)   . 

#endif
//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_EEPROM.inc   =====================================
/*
 *  library of EEPROM version 1.2
 *
 *  Created: 10.02.2017
 *  Author: Lihouzov Evgeny
 */

#ifdef _lib_EEPROM_rd_wr_byte_
#message define Include library for EEPROM in __FILE__

//*********************************************************************
EEPROM_read_byte:            //F,E- A 
#if defined(_M328DEF_INC_)||defined(_M328PDEF_INC_) 
   sbic EECR, EEPE           //Wait for completion of previous write
#else
   sbic EECR, EEWE
#endif
   rjmp EEPROM_read_byte     //Wait for completion of previous write

.if EEPROMEND>=256
   out  EEARL, E             //Set address in address register
   out  EEARH, F             //Set address in address register
.else
   out  EEARL, E             //Set address in address register
.endif   
   sbi  EECR,  EERE          //Start eeprom read by writing EERE
   in   A,     EEDR          //Read data from data register
  ret                        //
//*********************************************************************
EEPROM_write_byte:           //F,E- A 
#if defined(_M328DEF_INC_)||defined(_M328PDEF_INC_) 
   sbic EECR, EEPE           //Wait for completion of previous write
#else
   sbic EECR, EEWE
#endif
   rjmp EEPROM_write_byte    //Wait for completion of previous write
.if EEPROMEND>=256
   out  EEARH, F             //Set address in address register
   out  EEARL, E             //Set address in address register
.else
   out  EEAR,  E             //Set address in address register
.endif 
   out EEDR,   A             //Write data (r16) to data register
#if defined(_M328DEF_INC_)||defined(_M328PDEF_INC_)
   sbi EECR,EEMPE            //Write logical one to EEMPE
   sbi EECR,EEPE             //Start eeprom write by setting EEPE
#else
   sbi EECR,   EEMWE         //Write logical one to EEMPE
   sbi EECR,   EEWE          //Start eeprom write by setting EEPE
#endif
   
  ret                        //
//*********************************************************************
#endif
FBD0:  .DB  0x00, 0x01                                    //f:2 m:0  port_D.inc
FBD1:  .DB  0x01, 0x02                                    //f:2 m:0  port_D.inc
FBD2:  .DB  0x12, 0x04                                    //f:2 m:0  port_D.inc
FBD3:  .DB  0x06, 0x02                                    //f:2 m:0  time_counter_milliseconds.inc
FBD4:  .DB  0x01, 0x64, 0x00, 0x08                        //f:4 m:2  gener_impulse.inc
FBD5:  .DB  0x08, 0xB8, 0x0B, 0x09                        //f:4 m:3  time_TOFF.inc
FBD6:  .DB  0x02, 0x64, 0x00, 0x0B                        //f:4 m:2  gener_impulse.inc
FBD7:  .DB  0x0B, 0xB8, 0x0B, 0x0C                        //f:4 m:3  time_TOFF.inc
FBD8:  .DB  0x0C, 0x0E                                    //f:2 m:0  logic_not.inc
FBD9:  .DB  0x09, 0x0F                                    //f:2 m:0  logic_not.inc
FBD10: .DB  0x15, 0x64, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00 //f:8 m:3  logic_generator_16.inc
FBD11: .DB  0x04, 0x16                                    //f:2 m:0  logic_not.inc
FBD12: .DB  0x16, 0x15, 0x17, 0x00                        //f:3 m:0  logic_and.inc
FBD13: .DB  0x03, 0x18                                    //f:2 m:0  port_D.inc
FBD14: .DB  0x17, 0x19                                    //f:2 m:0  logic_not.inc
FBD15: .DB  0x18, 0x1A                                    //f:2 m:0  logic_not.inc
FBD16: .DB  0x23, 0x23, 0x23, 0x23, 0x1C, 0x04, 0x00, 0x00 //f:7 m:3  time_CTN.inc
FBD17: .DB  0x17, 0x1A, 0x23, 0x23, 0x03, 0x00, 0x00, 0x00 //f:7 m:3  time_CTN.inc
FBD18: .DB  0x0F, 0x02, 0x0A, 0x00                        //f:3 m:0  logic_and.inc
FBD19: .DB  0x0E, 0x01, 0x0D, 0x00                        //f:3 m:0  logic_and.inc
FBD20: .DB  0x0D, 0x10                                    //f:2 m:0  logic_not.inc
FBD21: .DB  0x0A, 0x11                                    //f:2 m:0  logic_not.inc
FBD22: .DB  0x08, 0x19                                    //f:2 m:0  port_B.inc
FBD23: .DB  0x0D, 0x0A, 0x23, 0x23, 0x00, 0x00, 0x00, 0x00 //f:7 m:3  time_CTN.inc
FBD24: .DB  0x00, 0x03, 0x05, 0x00                        //f:3 m:0  integer_more.inc
FBD25: .DB  0x05, 0x06                                    //f:2 m:0  logic_not.inc
FBD26: .DB  0x06, 0x23, 0x07, 0x00                        //f:3 m:0  logic_or.inc
FBD27: .DB  0x09, 0x10                                    //f:2 m:0  port_B.inc
FBD28: .DB  0x0A, 0x11                                    //f:2 m:0  port_B.inc
FBD29: .DB  0x05, 0xD0, 0x07, 0x12                        //f:4 m:3  time_TON.inc
FBD30: .DB  0x05, 0x14                                    //f:2 m:0  logic_not.inc
FBD31: .DB  0x0F, 0x07                                    //f:2 m:0  port_B.inc
FBD32: .DB  0x01, 0x05, 0x20, 0x00                        //f:3 m:0  logic_and.inc
FBD33: .DB  0x07, 0x64, 0x00, 0x21                        //f:4 m:2  gener_impulse.inc
FBD34: .DB  0x02, 0x05, 0x22, 0x00                        //f:3 m:0  logic_and.inc
FBD35: .DB  0x0D, 0x12                                    //f:2 m:0  port_D.inc
FBD36: .DB  0x09, 0x14, 0x13, 0x00                        //f:3 m:0  logic_and.inc
FBD37: .DB  0x0C, 0x13                                    //f:2 m:0  port_B.inc
FBD38: .DB  0x20, 0x22, 0x23, 0x23, 0x1B, 0x00, 0x00, 0x00 //f:7 m:3  time_CTN.inc
FBD39: .DB  0x1B, 0x1C, 0x1D, 0x00                        //f:3 m:0  integer_more.inc
FBD40: .DB  0x1D, 0x64, 0x00, 0x1F                        //f:4 m:2  gener_impulse.inc
FBD41: .DB  0x1F, 0x21, 0x1E, 0x00                        //f:4 m:1  logic_RS_trigger.inc
FBD42: .DB  0x0B, 0x1E                                    //f:2 m:0  port_B.inc
//=====================================   kernel.inc   =====================================


.MACRO Clear_All_Memory
//************    *******************
   ldi   XL, Low(SRAM_START)                  ;    
   ldi   XH, High(SRAM_START)                 ;    

.if SRAM_SIZE>255
   ldi   YL, Low(SRAM_SIZE)                   ;   
   ldi   YH, High(SRAM_SIZE)                  ;   
Initial_Memory:
   ST    X+, Zero                             ; 
   sbiw  Y,  1                                ; 
   brne  Initial_Memory                       ;  
.else 
   ldi   YL, SRAM_SIZE                        ;   
Initial_Memory:
   ST    X+, Zero                             ; 
   dec   YL                                   ; 
   brne  Initial_Memory                       ;  
.endif
.ENDMACRO

Read_cfg:	
        mov ZL, YL
        mov ZH, YH
        lpm 
	ADIW  YL, 1           ;  
	RET

//=========================     ======================
  .MACRO Get_Flash_Pointer                           ;  
     lpm                                             ;  
	 ADIW  ZL, 1                                     ;  
	 mov   Kern_A, Addr_Data 
     lpm                                             ;  
	 mov   ZH, Addr_Data                    ;  
	 mov   ZL, Kern_A                       ;            
  .ENDMACRO 

  .MACRO Get_Flash_Byte                              ;  
     lpm                                             ;  flash
	 ADIW  ZL, 1                                     ;  
	 mov   @0, Addr_Data                             ;  flash          
  .ENDMACRO 



//============================   =========================
Read_cfg_Set_Bit_Reg_A:
 rcall Read_cfg                       ;  
Set_Bit_Reg_A:
 ldi   A, 0b000000001
 sbrc  Addr_Data, 0
 lsl   A
 sbrc  Addr_Data, 1
 lsl   A
 sbrc  Addr_Data, 1
 lsl   A
 sbrc  Addr_Data, 2
 swap  A
ret


.MACRO Set_Adr_Uzl                     ;     
  ldi   ZL, Low(FBD_DATA_RAM)   ;    
  ldi   ZH, High(FBD_DATA_RAM)  ;   
  add   ZL, @0                ;  
  adc   ZH, Zero              ;  
  add   ZL, @0                ;  
  adc   ZH, Zero              ;            
.ENDMACRO   

Set_Adres_Uzl:
  ldi   ZL, Low(FBD_DATA_RAM)   ;    
  ldi   ZH, High(FBD_DATA_RAM)  ;   
  add   ZL, Addr_Data         ;  
  adc   ZH, Zero              ;  
  add   ZL, Addr_Data         ;  
  adc   ZH, Zero              ;             
ret;

Read_Cfg_Load_Uz1:
 rcall Read_cfg                       ;  
Load_Uz1:
 rcall Set_Adres_Uzl;  //Set_Adr_Uzl Addr_Data                ;     
 ld    Uz1L, Z+                       ;  
 ld    Uz1H, Z+                       ;  
ret

Read_Cfg_Load_Uz2:
 rcall Read_cfg                       ;  
Load_Uz2:
 rcall Set_Adres_Uzl;  //Set_Adr_Uzl Addr_Data                ;     
 ld    Uz2L, Z+                       ;  
 ld    Uz2H, Z+                       ;  
ret

Read_Cfg_Load_Uz3:
 rcall Read_cfg                       ;  
Load_Uz3:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 ld    Uz3L, Z+                       ;  
 ld    Uz3H, Z+                       ;  
ret

Read_Cfg_Save_Uz1:
 rcall Read_cfg                       ;  
Save_Uz1:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 st    Z+, Uz1L                       ;  
 st    Z+, Uz1H                       ;  
ret

Read_Cfg_Save_Uz2:
 rcall Read_cfg                       ;  
Save_Uz2:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 st    Z+, Uz2L                       ;  
 st    Z+, Uz2H                       ;  
ret

Read_Cfg_Save_Uz3:
 rcall Read_cfg                       ;  
Save_Uz3:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 st    Z+, Uz3L                       ;  
 st    Z+, Uz3H                       ;  
ret

//==============================  End kernel function ==============================================


 load_cfg:
.if RAMEND>=256
   ldi   A,  Low(RAMEND)      //   
   out   SPL, A              
   ldi   A, High(RAMEND)      //   
   out   SPH, A              
.else
   ldi   A, RAMEND            //   
   out   SPL, A              
.endif   

   clr   Zero                  //
   mov   One, Zero             // 1
   inc   One                   // 1
   Clear_All_Memory            //  
   sei 
//========= init cycle ==========
ldi   YL, Low(FBD0*2)                    //   flash 
ldi   YH, High(FBD0*2)                   //   flash 
rcall FBD0_init                     //port_D.inc (0,0,1)
ldi   YL, Low(FBD1*2)                    //   flash 
ldi   YH, High(FBD1*2)                   //   flash 
rcall FBD0_init                     //port_D.inc (0,1,2)
ldi   YL, Low(FBD2*2)                    //   flash 
ldi   YH, High(FBD2*2)                   //   flash 
rcall FBD0_init                     //port_D.inc (0,18,4)
ldi   YL, Low(FBD3*2)                    //   flash 
ldi   YH, High(FBD3*2)                   //   flash 
rcall FBD1_init                     //time_counter_milliseconds.inc (1,518)
ldi   XL, Low(FBD_DATA_RAM+82)           //    
ldi   XH, High(FBD_DATA_RAM+82)          //    
ldi   YL, Low(FBD10*2)                   //   flash 
ldi   YH, High(FBD10*2)                  //   flash 
rcall FBD5_init                     //logic_generator_16.inc (5,21,100,100,0,0)
ldi   YL, Low(FBD13*2)                   //   flash 
ldi   YH, High(FBD13*2)                  //   flash 
rcall FBD0_init                     //port_D.inc (0,3,24)
ldi   XL, Low(FBD_DATA_RAM+85)           //    
ldi   XH, High(FBD_DATA_RAM+85)          //    
ldi   YL, Low(FBD16*2)                   //   flash 
ldi   YH, High(FBD16*2)                  //   flash 
rcall FBD7_init                     //time_CTN.inc (7,35,35,35,35,28,4)
ldi   XL, Low(FBD_DATA_RAM+88)           //    
ldi   XH, High(FBD_DATA_RAM+88)          //    
ldi   YL, Low(FBD17*2)                   //   flash 
ldi   YH, High(FBD17*2)                  //   flash 
rcall FBD7_init                     //time_CTN.inc (7,23,26,35,35,3,0)
ldi   YL, Low(FBD22*2)                   //   flash 
ldi   YH, High(FBD22*2)                  //   flash 
rcall FBD8_init                     //port_B.inc (8,8,25)
ldi   XL, Low(FBD_DATA_RAM+91)           //    
ldi   XH, High(FBD_DATA_RAM+91)          //    
ldi   YL, Low(FBD23*2)                   //   flash 
ldi   YH, High(FBD23*2)                  //   flash 
rcall FBD7_init                     //time_CTN.inc (7,13,10,35,35,0,0)
ldi   YL, Low(FBD27*2)                   //   flash 
ldi   YH, High(FBD27*2)                  //   flash 
rcall FBD8_init                     //port_B.inc (8,9,16)
ldi   YL, Low(FBD28*2)                   //   flash 
ldi   YH, High(FBD28*2)                  //   flash 
rcall FBD8_init                     //port_B.inc (8,10,17)
ldi   YL, Low(FBD31*2)                   //   flash 
ldi   YH, High(FBD31*2)                  //   flash 
rcall FBD8_init                     //port_B.inc (8,15,7)
ldi   YL, Low(FBD35*2)                   //   flash 
ldi   YH, High(FBD35*2)                  //   flash 
rcall FBD0_init                     //port_D.inc (0,13,18)
ldi   YL, Low(FBD37*2)                   //   flash 
ldi   YH, High(FBD37*2)                  //   flash 
rcall FBD8_init                     //port_B.inc (8,12,19)
ldi   XL, Low(FBD_DATA_RAM+99)           //    
ldi   XH, High(FBD_DATA_RAM+99)          //    
ldi   YL, Low(FBD38*2)                   //   flash 
ldi   YH, High(FBD38*2)                  //   flash 
rcall FBD7_init                     //time_CTN.inc (7,32,34,35,35,27,0)
ldi   XL, Low(FBD_DATA_RAM+104)          //    
ldi   XH, High(FBD_DATA_RAM+104)         //    
ldi   YL, Low(FBD41*2)                   //   flash 
ldi   YH, High(FBD41*2)                  //   flash 
rcall FBD12_init                    //logic_RS_trigger.inc (12,31,33,30,0)
ldi   YL, Low(FBD42*2)                   //   flash 
ldi   YH, High(FBD42*2)                  //   flash 
rcall FBD8_init                     //port_B.inc (8,11,30)
//========= run cycle ==========
Run_FBD:       //main cycle
ldi   YL, Low(FBD0*2)                    //   flash 
ldi   YH, High(FBD0*2)                   //   flash 
rcall FBD0_run                      //port_D.inc (0,0,1)
ldi   YL, Low(FBD1*2)                    //   flash 
ldi   YH, High(FBD1*2)                   //   flash 
rcall FBD0_run                      //port_D.inc (0,1,2)
ldi   YL, Low(FBD2*2)                    //   flash 
ldi   YH, High(FBD2*2)                   //   flash 
rcall FBD0_run                      //port_D.inc (0,18,4)
ldi   YL, Low(FBD3*2)                    //   flash 
ldi   YH, High(FBD3*2)                   //   flash 
rcall FBD1_run                      //time_counter_milliseconds.inc (1,518)
ldi   XL, Low(FBD_DATA_RAM+72)           //    
ldi   XH, High(FBD_DATA_RAM+72)          //    
ldi   YL, Low(FBD4*2)                    //   flash 
ldi   YH, High(FBD4*2)                   //   flash 
rcall FBD2_run                      //gener_impulse.inc (2,1,100,8)
ldi   XL, Low(FBD_DATA_RAM+74)           //    
ldi   XH, High(FBD_DATA_RAM+74)          //    
ldi   YL, Low(FBD5*2)                    //   flash 
ldi   YH, High(FBD5*2)                   //   flash 
rcall FBD3_run                      //time_TOFF.inc (3,8,3000,9)
ldi   XL, Low(FBD_DATA_RAM+77)           //    
ldi   XH, High(FBD_DATA_RAM+77)          //    
ldi   YL, Low(FBD6*2)                    //   flash 
ldi   YH, High(FBD6*2)                   //   flash 
rcall FBD2_run                      //gener_impulse.inc (2,2,100,11)
ldi   XL, Low(FBD_DATA_RAM+79)           //    
ldi   XH, High(FBD_DATA_RAM+79)          //    
ldi   YL, Low(FBD7*2)                    //   flash 
ldi   YH, High(FBD7*2)                   //   flash 
rcall FBD3_run                      //time_TOFF.inc (3,11,3000,12)
ldi   YL, Low(FBD8*2)                    //   flash 
ldi   YH, High(FBD8*2)                   //   flash 
rcall FBD4_run                      //logic_not.inc (4,12,14)
ldi   YL, Low(FBD9*2)                    //   flash 
ldi   YH, High(FBD9*2)                   //   flash 
rcall FBD4_run                      //logic_not.inc (4,9,15)
ldi   XL, Low(FBD_DATA_RAM+82)           //    
ldi   XH, High(FBD_DATA_RAM+82)          //    
ldi   YL, Low(FBD10*2)                   //   flash 
ldi   YH, High(FBD10*2)                  //   flash 
rcall FBD5_run                      //logic_generator_16.inc (5,21,100,100,0,0)
ldi   YL, Low(FBD11*2)                   //   flash 
ldi   YH, High(FBD11*2)                  //   flash 
rcall FBD4_run                      //logic_not.inc (4,4,22)
ldi   YL, Low(FBD12*2)                   //   flash 
ldi   YH, High(FBD12*2)                  //   flash 
rcall FBD6_run                      //logic_and.inc (6,22,21,23)
ldi   YL, Low(FBD13*2)                   //   flash 
ldi   YH, High(FBD13*2)                  //   flash 
rcall FBD0_run                      //port_D.inc (0,3,24)
ldi   YL, Low(FBD14*2)                   //   flash 
ldi   YH, High(FBD14*2)                  //   flash 
rcall FBD4_run                      //logic_not.inc (4,23,25)
ldi   YL, Low(FBD15*2)                   //   flash 
ldi   YH, High(FBD15*2)                  //   flash 
rcall FBD4_run                      //logic_not.inc (4,24,26)
ldi   XL, Low(FBD_DATA_RAM+85)           //    
ldi   XH, High(FBD_DATA_RAM+85)          //    
ldi   YL, Low(FBD16*2)                   //   flash 
ldi   YH, High(FBD16*2)                  //   flash 
rcall FBD7_run                      //time_CTN.inc (7,35,35,35,35,28,4)
ldi   XL, Low(FBD_DATA_RAM+88)           //    
ldi   XH, High(FBD_DATA_RAM+88)          //    
ldi   YL, Low(FBD17*2)                   //   flash 
ldi   YH, High(FBD17*2)                  //   flash 
rcall FBD7_run                      //time_CTN.inc (7,23,26,35,35,3,0)
ldi   YL, Low(FBD18*2)                   //   flash 
ldi   YH, High(FBD18*2)                  //   flash 
rcall FBD6_run                      //logic_and.inc (6,15,2,10)
ldi   YL, Low(FBD19*2)                   //   flash 
ldi   YH, High(FBD19*2)                  //   flash 
rcall FBD6_run                      //logic_and.inc (6,14,1,13)
ldi   YL, Low(FBD20*2)                   //   flash 
ldi   YH, High(FBD20*2)                  //   flash 
rcall FBD4_run                      //logic_not.inc (4,13,16)
ldi   YL, Low(FBD21*2)                   //   flash 
ldi   YH, High(FBD21*2)                  //   flash 
rcall FBD4_run                      //logic_not.inc (4,10,17)
ldi   YL, Low(FBD22*2)                   //   flash 
ldi   YH, High(FBD22*2)                  //   flash 
rcall FBD8_run                      //port_B.inc (8,8,25)
ldi   XL, Low(FBD_DATA_RAM+91)           //    
ldi   XH, High(FBD_DATA_RAM+91)          //    
ldi   YL, Low(FBD23*2)                   //   flash 
ldi   YH, High(FBD23*2)                  //   flash 
rcall FBD7_run                      //time_CTN.inc (7,13,10,35,35,0,0)
ldi   YL, Low(FBD24*2)                   //   flash 
ldi   YH, High(FBD24*2)                  //   flash 
rcall FBD9_run                      //integer_more.inc (9,0,3,5)
ldi   YL, Low(FBD25*2)                   //   flash 
ldi   YH, High(FBD25*2)                  //   flash 
rcall FBD4_run                      //logic_not.inc (4,5,6)
ldi   YL, Low(FBD26*2)                   //   flash 
ldi   YH, High(FBD26*2)                  //   flash 
rcall FBD10_run                     //logic_or.inc (10,6,35,7)
ldi   YL, Low(FBD27*2)                   //   flash 
ldi   YH, High(FBD27*2)                  //   flash 
rcall FBD8_run                      //port_B.inc (8,9,16)
ldi   YL, Low(FBD28*2)                   //   flash 
ldi   YH, High(FBD28*2)                  //   flash 
rcall FBD8_run                      //port_B.inc (8,10,17)
ldi   XL, Low(FBD_DATA_RAM+94)           //    
ldi   XH, High(FBD_DATA_RAM+94)          //    
ldi   YL, Low(FBD29*2)                   //   flash 
ldi   YH, High(FBD29*2)                  //   flash 
rcall FBD11_run                     //time_TON.inc (11,5,2000,18)
ldi   YL, Low(FBD30*2)                   //   flash 
ldi   YH, High(FBD30*2)                  //   flash 
rcall FBD4_run                      //logic_not.inc (4,5,20)
ldi   YL, Low(FBD31*2)                   //   flash 
ldi   YH, High(FBD31*2)                  //   flash 
rcall FBD8_run                      //port_B.inc (8,15,7)
ldi   YL, Low(FBD32*2)                   //   flash 
ldi   YH, High(FBD32*2)                  //   flash 
rcall FBD6_run                      //logic_and.inc (6,1,5,32)
ldi   XL, Low(FBD_DATA_RAM+97)           //    
ldi   XH, High(FBD_DATA_RAM+97)          //    
ldi   YL, Low(FBD33*2)                   //   flash 
ldi   YH, High(FBD33*2)                  //   flash 
rcall FBD2_run                      //gener_impulse.inc (2,7,100,33)
ldi   YL, Low(FBD34*2)                   //   flash 
ldi   YH, High(FBD34*2)                  //   flash 
rcall FBD6_run                      //logic_and.inc (6,2,5,34)
ldi   YL, Low(FBD35*2)                   //   flash 
ldi   YH, High(FBD35*2)                  //   flash 
rcall FBD0_run                      //port_D.inc (0,13,18)
ldi   YL, Low(FBD36*2)                   //   flash 
ldi   YH, High(FBD36*2)                  //   flash 
rcall FBD6_run                      //logic_and.inc (6,9,20,19)
ldi   YL, Low(FBD37*2)                   //   flash 
ldi   YH, High(FBD37*2)                  //   flash 
rcall FBD8_run                      //port_B.inc (8,12,19)
ldi   XL, Low(FBD_DATA_RAM+99)           //    
ldi   XH, High(FBD_DATA_RAM+99)          //    
ldi   YL, Low(FBD38*2)                   //   flash 
ldi   YH, High(FBD38*2)                  //   flash 
rcall FBD7_run                      //time_CTN.inc (7,32,34,35,35,27,0)
ldi   YL, Low(FBD39*2)                   //   flash 
ldi   YH, High(FBD39*2)                  //   flash 
rcall FBD9_run                      //integer_more.inc (9,27,28,29)
ldi   XL, Low(FBD_DATA_RAM+102)          //    
ldi   XH, High(FBD_DATA_RAM+102)         //    
ldi   YL, Low(FBD40*2)                   //   flash 
ldi   YH, High(FBD40*2)                  //   flash 
rcall FBD2_run                      //gener_impulse.inc (2,29,100,31)
ldi   XL, Low(FBD_DATA_RAM+104)          //    
ldi   XH, High(FBD_DATA_RAM+104)         //    
ldi   YL, Low(FBD41*2)                   //   flash 
ldi   YH, High(FBD41*2)                  //   flash 
rcall FBD12_run                     //logic_RS_trigger.inc (12,31,33,30,0)
ldi   YL, Low(FBD42*2)                   //   flash 
ldi   YH, High(FBD42*2)                  //   flash 
rcall FBD8_run                      //port_B.inc (8,11,30)
rjmp  Run_FBD
.DSEG
RAM_global: .BYTE FBD_DATA_RAM-SRAM_START
RAM_uzel:   .BYTE 72
RAM_FBD:    .BYTE 33
RAM_stack:  .BYTE 8
